package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceInfoDao;
import com.artfess.device.base.dao.DeviceProductInfoDao;
import com.artfess.device.base.dao.DeviceProductTypeDao;
import com.artfess.device.base.manager.DeviceProductInfoManager;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceProductInfo;
import com.artfess.device.base.model.DeviceProductType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 设备产品信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Service
public class DeviceProductInfoManagerImpl extends BaseManagerImpl<DeviceProductInfoDao, DeviceProductInfo> implements DeviceProductInfoManager {

    @Resource
    private DeviceProductTypeDao productTypeDao;

    @Resource
    private DeviceInfoDao deviceInfoDao;

    @Override
    @Transactional
    public String createInfo(DeviceProductInfo t) {
        int insert = this.baseMapper.insert(t);
        if(insert > 0) {
            DeviceProductType deviceProductType = productTypeDao.selectById(t.getTypeId());
            if(null != deviceProductType) {
                t.setFullId(deviceProductType.getFullId() + "/" + t.getId());
                t.setFullName(deviceProductType.getFullName() + "/" + t.getName());
            }

            this.baseMapper.updateById(t);
            return t.getId();
        }
        return null;

    }

    @Override
    @Transactional
    public String updateInfo(DeviceProductInfo t) {
        DeviceProductType deviceProductType = productTypeDao.selectById(t.getTypeId());
        if(null != deviceProductType) {
            t.setFullId(deviceProductType.getFullId() + "/" + t.getId());
            t.setFullName(deviceProductType.getFullName() + "/" + t.getName());
        }

        QueryWrapper<DeviceInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("product_id_", t.getId());
        List<DeviceInfo> deviceInfos = deviceInfoDao.selectList(queryWrapper);
        deviceInfos.forEach(deviceInfo -> {
            deviceInfo.setFullName(t.getFullName()+ "/" + deviceInfo.getName());
            this.deviceInfoDao.updateById(deviceInfo);
        });

        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public List<DeviceProductInfo> findAll(DeviceProductInfo productInfo) {
        QueryWrapper<DeviceProductInfo> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(productInfo.getCode())){
            queryWrapper.like("code_", productInfo.getCode());
        }

        if(StringUtils.isNotBlank(productInfo.getName())){
            queryWrapper.like("name_", productInfo.getName());
        }

        if(StringUtils.isNotBlank(productInfo.getDeviceType())){
            queryWrapper.like("device_type_", productInfo.getDeviceType());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        //已发布产品
        queryWrapper.eq("publish_status_", "1");
        queryWrapper.orderByAsc("sn_");
        return this.baseMapper.selectList(queryWrapper);
    }

    @Override
    public boolean publish(String id) {
        DeviceProductInfo productInfo = this.baseMapper.selectById(id);
        productInfo.setPublishStatus("1");
        int i = this.baseMapper.updateById(productInfo);
        if(i > 0 ) {
            return true;
        }
        return false;
    }

    @Override
    public DeviceProductType findByDeviceId(String deviceId) {

        return this.baseMapper.findByDeviceId(deviceId);
    }
}
