package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.device.base.model.DeviceWarnConf;

/**
 * 设备告警配置 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceWarnConfManager extends BaseManager<DeviceWarnConf> {

    /**
     * 创建告警配置
     * @param t
     * @return
     */
    String createInfo(DeviceWarnConf t);

    /**
     * 修改告警配置
     * @param t
     * @return
     */
    String updateInfo(DeviceWarnConf t);

    /**
     * 根据id获取告警配置
     * @param id
     * @return
     */
    DeviceWarnConf findById(String id);

    /**
     * 启禁用告警配置
     * @param entity
     * @return
     */
    boolean modifyEnabled(DeviceWarnConf entity);
}
