package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.device.base.model.DeviceProductWarnConf;

import java.util.List;

/**
 * 产品告警配置 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceProductWarnConfManager extends BaseManager<DeviceProductWarnConf> {

    /**
     * 根据id获取产品告警配置信息
     * @param id
     * @return
     */
    DeviceProductWarnConf findById(String id);

    /**
     * 修改产品告警配置信息
     * @param t
     * @return
     */
    boolean updateInfo(DeviceProductWarnConf t);

    /**
     * 保存产品告警配置信息
     * @param t
     * @return
     */
    boolean saveInfo(DeviceProductWarnConf t);

    /**
     * 根据查询条件获取产品告警配置列表
     * @param conf
     * @return
     */
    List<DeviceProductWarnConf> findByParams(DeviceProductWarnConf conf);
}
