package com.artfess.device.base.dao;

import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.model.DeviceWarnInfo;
import com.artfess.device.base.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 设备告警信息 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceWarnInfoDao extends BaseMapper<DeviceWarnInfo> {

    Integer findByDeviceType(@Param("deviceType") String deviceType);

    /**
     * 获取设备最新的报警数据
     * @param deviceCode 设备编码
     * @param warnType 报警类型（1：设备故障报警，2：设备监测数据报警）
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2022/8/1 17:53
     */
    List<DeviceWarnInfo> getNewWarnInfo(@Param("deviceCode")String deviceCode, @Param("warnType")String warnType);


    List<StatisticsVo> statisticsWarn(@Param("dto") StatisticsDto dto);

    List<StatisticsVo> warnCountMonthly();

    IPage<DeviceWarnInfo> queryPage(IPage<DeviceWarnInfo> convert2IPage, @Param(Constants.WRAPPER) QueryWrapper<DeviceWarnInfo> convert2Wrapper);

    List<StatisticsVo> warnCountCurrently();

    List<StatisticsVo> statisticsWarnSub(@Param("dto") StatisticsDto dto);
}
