package com.artfess.device.base.dao;

import com.artfess.device.base.model.DeviceVideoPoint;
import com.artfess.device.base.vo.VideoPointVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 视频点位信息表（DEVICE_VIDEO_POINT） Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-19
 */
public interface DeviceVideoPointDao extends BaseMapper<DeviceVideoPoint> {

    void deleteZoneRes(@Param("zoneCode") String zoneCode);

    /**
     * @Description: 根据摄像头code查询摄像头信息
     * @param videoCode 摄像头code
     * @Return: java.util.List<com.artfess.bzzgj.device.vo.VideoPointVo>
     * @Author: chens
     * @Date: 2022/9/14 13:19
     */
    List<VideoPointVo> findByVideoCode(@Param("videoCode") String videoCode);
}
