package com.artfess.device.base.dao;

import com.artfess.device.base.model.DeviceVideoBase;
import com.artfess.device.base.model.DeviceVideoPoint;
import com.artfess.device.base.model.DeviceVideoZone;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 视频目录基础信息表（DEVICE_VIDEO_BASE） Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-19
 */
public interface DeviceVideoBaseDao extends BaseMapper<DeviceVideoBase> {

    IPage<DeviceVideoPoint> findByPage(IPage<DeviceVideoBase> convert2IPage, @Param(Constants.WRAPPER) QueryWrapper<DeviceVideoBase> convert2Wrapper);

    List<DeviceVideoPoint> findByZoneCode(@Param("vo") Map<String, Object> collectVo);

    List<DeviceVideoZone> findByRes();

    List<String> findCodeByPlatform(@Param("platform") String platform);
}
