package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.device.base.manager.DeviceWarnInfoManager;
import com.artfess.device.base.model.DeviceWarnInfo;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 设备告警信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Slf4j
@RestController
@Api(tags = "设施设备-设备告警信息管理")
@RequestMapping("/device/warnInfo/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceWarnInfoController extends BaseController<DeviceWarnInfoManager, DeviceWarnInfo> {

}
