package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceBaseParamsConfManager;
import com.artfess.device.base.manager.DeviceBaseSpareManager;
import com.artfess.device.base.model.DeviceBaseSpare;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 对备品件进行管理 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Slf4j
@RestController
@Api(tags = "设施设备-备品件管理")
@RequestMapping("/device/base/spare/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceBaseSpareController extends BaseController<DeviceBaseSpareManager, DeviceBaseSpare> {

    @Autowired
    private DeviceBaseParamsConfManager deviceBaseParamsConfManager;

    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<DeviceBaseSpare> query(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<DeviceBaseSpare> queryFilter) {
        return baseService.findByPage(queryFilter);
    }

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) DeviceBaseSpare t) {
        boolean result = baseService.save(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        deviceBaseParamsConfManager.saveParamsValue(t.getParamsValueList(), t.getId());
        return new CommonResult<>();
    }


    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class})  DeviceBaseSpare t) {
        boolean result = baseService.updateById(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        deviceBaseParamsConfManager.saveParamsValue(t.getParamsValueList(), t.getId());
        return new CommonResult<>();
    }

}
