package com.artfess.device.monitor.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.device.monitor.model.DeviceDataBarricadeStatus;
import com.artfess.device.monitor.manager.DeviceDataBarricadeStatusManager;

/**
 * 实时监控-路障设备状态信息（DEVICE_DATA_BARRICADE_STATUS） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2022-09-13
 */
@Slf4j
@RestController
@Api(tags = "实时监控-路障设备状态信息")
@RequestMapping("/deviceDataBarricadeStatus/v1/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceDataBarricadeStatusController extends BaseController<DeviceDataBarricadeStatusManager, DeviceDataBarricadeStatus> {

}
