package com.artfess.device.base.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Arrays;

/**
 * @Author : min.wu
 * @Date: 2022/08/22 17:21
 */
@Data
public class DeviceWarnInfoVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    private String eventId;

    @ApiModelProperty(value = "事件来源")
    private String eventSrc ="设备管理" ;

    @ApiModelProperty(value = "事件来源Id")
    private String eventSrcId ;

    @ApiModelProperty(value = "事件名称")
    private String eventTitle ;

    @ApiModelProperty(value = "事件类型1：旅客上报，2：设备上报，3：视频算法上报，4：综管上报，5：流量上报")
    private Integer eventClass = 2;

    @ApiModelProperty(value = "事件子类型 1：标识牌，2：低洼积水，3：危险源，4：路障，5：摄像头，6：蓝牙信标，7：信息发布屏")
    private String eventSubClass;

    @ApiModelProperty(value = "紧急等级 0（普通）1（紧急）")
    private Integer eventLevel;

    @ApiModelProperty(value = "事件描述")
    private String eventDesc;

    @ApiModelProperty(value = "发生时间")
    private String eventTime;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;

    @ApiModelProperty(value = "区域名称")
    private String regionName;

    @ApiModelProperty(value = "事件地址")
    private String eventAddr;

    @ApiModelProperty(value = "纬度")
    private BigDecimal eventLat;

    @ApiModelProperty(value = "经度")
    private BigDecimal eventLng;

    @ApiModelProperty(value = "经纬度（逗号分割106.555899,29.610506）")
    private String lnglat;

    @ApiModelProperty(value = "上报图片URL列表")
    private String[] eventPics;

    @ApiModelProperty(value = "设备唯一识别码")
    private String devCode;

    @ApiModelProperty(value = "设备名")
    private String devName;

    @ApiModelProperty(value = "事件类型 1: 故障，2：正常上报")
    private Integer eventType;

    @Override
    public String toString() {
        return "DeviceWarnInfoVo{" +
                "eventId='" + eventId + '\'' +
                ", eventSrc='" + eventSrc + '\'' +
                ", eventSrcId='" + eventSrcId + '\'' +
                ", eventTitle='" + eventTitle + '\'' +
                ", eventClass=" + eventClass +
                ", eventSubClass='" + eventSubClass + '\'' +
                ", eventLevel=" + eventLevel +
                ", eventDesc='" + eventDesc + '\'' +
                ", eventTime='" + eventTime + '\'' +
                ", regionCode='" + regionCode + '\'' +
                ", regionName='" + regionName + '\'' +
                ", eventAddr='" + eventAddr + '\'' +
                ", eventLat=" + eventLat +
                ", eventLng=" + eventLng +
                ", lnglat='" + lnglat + '\'' +
                ", eventPics=" + Arrays.toString(eventPics) +
                ", devCode='" + devCode + '\'' +
                ", devName='" + devName + '\'' +
                ", eventType=" + eventType +
                '}';
    }
}
