package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.device.base.model.DeviceBaseParamsConf;
import com.artfess.device.base.model.DeviceBaseParamsValue;

import java.util.List;

/**
 * 基础扩展信息表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-19
 */
public interface DeviceBaseParamsConfManager extends BaseManager<DeviceBaseParamsConf> {

    /**
     * 获取基础扩展信息列表
     * @param conf
     * @return
     */
    List<DeviceBaseParamsConf> findAll(DeviceBaseParamsConf conf);

    /**
     * 获取扩展信息内容列表
     * @param value
     * @return
     */
    List<DeviceBaseParamsValue> getConfValue(DeviceBaseParamsValue value);

    /**
     * 保存扩展信息
     * @param values
     * @param baseId
     */
    void saveParamsValue(List<DeviceBaseParamsValue> values, String baseId);
}
