package com.artfess.device.base.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceMetadataPropertiesManager;
import com.artfess.device.base.model.DeviceMetadataProperties;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 产品物模型属性 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Slf4j
@RestController
@Api(tags = "设施设备-产品物模型属性")
@RequestMapping("/device/metadata/properties/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceMetadataPropertiesController extends BaseController<DeviceMetadataPropertiesManager, DeviceMetadataProperties> {


    @PostMapping("/findAll")
    @ApiOperation("获取物模型属性列表(支持产品id过滤)")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取物模型属性列表")
    public CommonResult<String> findAll(@ApiParam(name = "model", value = "获取物模型属性列表") @RequestBody DeviceMetadataProperties entity) {
        log.info("获取物模型属性列表:{}", JSON.toJSONString(entity));
        List<DeviceMetadataProperties> list = baseService.findAll(entity);
        return CommonResult.success(list, null);
    }

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) DeviceMetadataProperties t) {
        this.baseService.vaild(t);
        boolean result = baseService.save(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }


    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class})  DeviceMetadataProperties t) {
        this.baseService.vaild(t);
        boolean result = baseService.updateById(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }
}
