/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.utils;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.utils.EasyPoiStyle;
import com.artfess.device.base.vo.StatisticsVo;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.google.common.collect.Maps;
import io.jsonwebtoken.lang.Collections;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.springframework.util.Assert;

public class BizUtils {
    public static ExportParams getExportParams(String fileName) {
        ExportParams exportParams = new ExportParams(null, fileName);
        exportParams.setStyle(EasyPoiStyle.class);
        exportParams.setType(ExcelType.HSSF);
        return exportParams;
    }

    public static String getDicCodeByValue(List<DictModel> dic, String value) {
        if (Collections.isEmpty(dic)) {
            return "";
        }
        for (DictModel ele : dic) {
            if (!ele.getName().equals(value)) continue;
            return ele.getValue();
        }
        return "";
    }

    public static String getDicValueByCode(List<DictModel> dic, String code) {
        if (Collections.isEmpty(dic)) {
            return "";
        }
        for (DictModel ele : dic) {
            if (!ele.getValue().equals(code)) continue;
            return ele.getName();
        }
        return "";
    }

    public static Boolean checkLevel(DeviceInfo device) {
        Assert.notNull((Object)((Object)device), (String)"\u6743\u9650\u68c0\u67e5\u8bbe\u5907\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        IUser user = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)user) || BeanUtils.isEmpty((Object)user.getUserLevel()) || user.getUserLevel() < device.getLevel()) {
            throw new RuntimeException((StringUtil.isNotEmpty((String)device.getId()) ? "\u64cd\u4f5c\u3010" + device.getName() + "\u3011" : "") + "\u6743\u9650\u4e0d\u8db3\uff1a\u6240\u9700\u7ea7\u522b\u4e3a\u3010" + device.getLevel() + "\u3011\uff0c\u5f53\u524d\u7528\u6237\u3010" + user.getFullname() + "\u3011\u62e5\u6709\u7684\u8bbe\u5907\u64cd\u4f5c\u6743\u9650\u4e3a\u3010" + user.getUserLevel() + "\u3011\uff01");
        }
        return true;
    }

    public static List<StatisticsVo> handleEmptyResult(Integer endtime, String inputTime, List<StatisticsVo> data) {
        ArrayList<StatisticsVo> emptyResult = new ArrayList<StatisticsVo>();
        block0: for (int i = 1; i <= endtime; ++i) {
            String time = inputTime + (i < 10 ? "-0" : "-") + i;
            for (StatisticsVo r : data) {
                if (!r.getTime().equals(time)) continue;
                continue block0;
            }
            emptyResult.add(new StatisticsVo(time, Lists.newArrayList()));
        }
        return emptyResult;
    }

    public static <K extends Comparable<? super K>, V> Map<K, V> sortByKey(Map<K, V> map, boolean isDesc) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (isDesc) {
            map.entrySet().stream().sorted(Map.Entry.comparingByKey().reversed()).forEachOrdered(e -> result.put(e.getKey(), e.getValue()));
        } else {
            map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> result.put(e.getKey(), e.getValue()));
        }
        return result;
    }
}

