/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.base.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DeviceStatusEnum;
import com.artfess.base.enums.EnableStatusEnum;
import com.artfess.base.enums.ProductTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.device.base.dao.DeviceBaseAreaDao;
import com.artfess.device.base.dao.DeviceBaseCompanyDao;
import com.artfess.device.base.dao.DeviceBaseUserDao;
import com.artfess.device.base.dao.DeviceInfoDao;
import com.artfess.device.base.dao.DeviceParamsValueDao;
import com.artfess.device.base.dao.DeviceProductInfoDao;
import com.artfess.device.base.dao.DeviceRelationContractDao;
import com.artfess.device.base.dao.DeviceStatusLogDao;
import com.artfess.device.base.manager.DeviceInfoManager;
import com.artfess.device.base.manager.DeviceVideoPointManager;
import com.artfess.device.base.manager.DeviceWarnInfoManager;
import com.artfess.device.base.model.DeviceBaseArea;
import com.artfess.device.base.model.DeviceBaseCompany;
import com.artfess.device.base.model.DeviceBaseUser;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceParamsValue;
import com.artfess.device.base.model.DeviceProductInfo;
import com.artfess.device.base.model.DeviceRelationContract;
import com.artfess.device.base.model.DeviceStatusLog;
import com.artfess.device.base.model.DeviceVideoPoint;
import com.artfess.device.base.utils.BizUtils;
import com.artfess.device.base.vo.CountVo;
import com.artfess.device.base.vo.FailureDeviceCountVo;
import com.artfess.device.base.vo.HomeRealTimeVo;
import com.artfess.device.base.vo.StatisticsVo;
import com.artfess.rocketmq.producer.RocketMQProducer;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DeviceInfoManagerImpl
extends BaseManagerImpl<DeviceInfoDao, DeviceInfo>
implements DeviceInfoManager {
    @Resource
    private DeviceProductInfoDao deviceProductInfoDao;
    @Resource
    private DeviceRelationContractDao deviceRelationContractDao;
    @Resource
    private DeviceParamsValueDao paramsValueDao;
    @Resource
    private DeviceBaseCompanyDao companyDao;
    @Resource
    private DeviceBaseUserDao deviceBaseUserDao;
    @Resource
    private DeviceBaseAreaDao areaDao;
    @Resource
    DeviceStatusLogDao statusLogDao;
    @Autowired
    private DeviceWarnInfoManager warnInfoManager;
    @Autowired
    private RocketMQProducer rocketMQUtils;
    @Autowired
    private DeviceVideoPointManager videoPointManager;
    @Resource
    private SysDictionaryManager sdm;

    @Override
    public List<DeviceInfo> findAll(DeviceInfo entity) {
        entity.setFlag(1);
        return ((DeviceInfoDao)this.baseMapper).findByParams(entity);
    }

    @Override
    @Transactional
    public String createInfo(DeviceInfo t) {
        t.setIsLock("0");
        t.setFlag(1);
        BizUtils.checkLevel(t);
        int insert = ((DeviceInfoDao)this.baseMapper).insert((Object)t);
        if (insert > 0) {
            DeviceProductInfo productInfo;
            List<DeviceRelationContract> contractList = t.getContractList();
            if (!CollectionUtils.isEmpty(contractList)) {
                contractList.forEach(contract -> {
                    contract.setDeviceId(t.getId());
                    this.deviceRelationContractDao.insert(contract);
                });
            }
            if (null != (productInfo = (DeviceProductInfo)((Object)this.deviceProductInfoDao.selectById((Serializable)((Object)t.getProductId()))))) {
                t.setFullName(productInfo.getFullName() + "/" + t.getName());
            }
            ((DeviceInfoDao)this.baseMapper).updateById((Object)t);
            this.processParamsValue(t.getParamsValueList(), t.getId());
            return t.getId();
        }
        return null;
    }

    private void processParamsValue(List<DeviceParamsValue> paramsValueList, String deviceId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"device_id_", (Object)deviceId);
        this.paramsValueDao.delete((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(paramsValueList)) {
            return;
        }
        paramsValueList.forEach(value -> {
            value.setDeviceId(deviceId);
            this.paramsValueDao.insert(value);
        });
    }

    @Override
    @Transactional
    public String updateInfo(DeviceInfo t) {
        DeviceProductInfo productInfo = (DeviceProductInfo)((Object)this.deviceProductInfoDao.selectById((Serializable)((Object)t.getProductId())));
        if (null != productInfo) {
            t.setFullName(productInfo.getFullName() + "/" + t.getName());
        }
        BizUtils.checkLevel(t);
        ((DeviceInfoDao)this.baseMapper).updateById((Object)t);
        this.processParamsValue(t.getParamsValueList(), t.getId());
        return t.getId();
    }

    @Override
    public JSONObject getDeviceInfo(DeviceInfo entity) {
        JSONObject result = new JSONObject();
        List<DeviceInfo> all = ((DeviceInfoDao)this.getBaseMapper()).findByParams(entity);
        this.handleJsonResult(result, "0", all);
        Map<String, List<DeviceInfo>> deviceStatus = all.stream().collect(Collectors.groupingBy(DeviceInfo::getStatus));
        for (Map.Entry<String, List<DeviceInfo>> online : deviceStatus.entrySet()) {
            this.handleJsonResult(result, online.getKey(), online.getValue());
        }
        Map<Boolean, List<DeviceInfo>> banStatus = all.stream().collect(Collectors.partitioningBy(e -> 0 == e.getFlag()));
        for (Map.Entry<Boolean, List<DeviceInfo>> ban : banStatus.entrySet()) {
            this.handleJsonResult(result, ban.getKey() != false ? "10" : "11", ban.getValue());
        }
        return result;
    }

    private void handleJsonResult(JSONObject result, String key, List<DeviceInfo> detailData) {
        JSONObject data = new JSONObject();
        data.put("count", (Object)detailData.size());
        JSONArray detail = new JSONArray();
        detail.add(detailData);
        data.put("detail", (Object)detail);
        result.put(key, (Object)data);
    }

    @Override
    public boolean modifyEnabled(DeviceInfo t) {
        DeviceInfo entity = (DeviceInfo)((Object)this.getById((Serializable)((Object)t.getId())));
        if (null == entity) {
            return false;
        }
        BizUtils.checkLevel(entity);
        entity.setFlag(EnableStatusEnum.Y.getType().equals(entity.getFlag()) ? EnableStatusEnum.N.getType() : EnableStatusEnum.Y.getType());
        entity.setUpdateTime(LocalDateTime.now());
        boolean b = this.saveOrUpdate((Object)entity);
        return b;
    }

    @Override
    @Transactional
    public Boolean updateDeviceStatus(String deviceCode, String deviceType, String status) {
        Assert.hasText((String)deviceCode, (String)"\u8bbe\u5907\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)status, (String)"\u8bbe\u5907\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Integer result = null;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code_", (Object)deviceCode);
        DeviceInfo deviceInfo = (DeviceInfo)((Object)((DeviceInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        if (deviceInfo != null && !deviceInfo.getStatus().equals(status)) {
            deviceInfo.setStatus(status);
            deviceInfo.setLastTime(LocalDateTime.now());
            result = ((DeviceInfoDao)this.baseMapper).updateById((Object)deviceInfo);
        }
        QueryWrapper statusWrapper = new QueryWrapper();
        statusWrapper.eq((Object)"device_code_", (Object)deviceCode);
        statusWrapper.eq((Object)"end_time_", (Object)"9999-12-31 23:59:59");
        DeviceStatusLog deviceStatusLog = (DeviceStatusLog)((Object)this.statusLogDao.selectOne((Wrapper)statusWrapper));
        if (deviceStatusLog != null) {
            LocalDateTime times = LocalDateTime.now();
            if (!deviceStatusLog.getDeviceStatus().equals(status)) {
                Duration duration = Duration.between(deviceStatusLog.getStartTime(), times);
                deviceStatusLog.setTimeLength(duration.toMinutes());
                deviceStatusLog.setEndTime(times);
                deviceStatusLog.setLastTime(LocalDateTime.now());
                this.statusLogDao.updateById((Object)deviceStatusLog);
                DeviceStatusLog newDeviceStatusLog = new DeviceStatusLog();
                newDeviceStatusLog.setDeviceCode(deviceCode);
                newDeviceStatusLog.setDeviceStatus(status);
                newDeviceStatusLog.setDeviceType(deviceType);
                newDeviceStatusLog.setStartTime(times);
                newDeviceStatusLog.setEndTime(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
                this.statusLogDao.insert((Object)newDeviceStatusLog);
            }
            HashMap<String, String> deviceStatus = new HashMap<String, String>();
            deviceStatus.put("deviceCode", deviceCode);
            deviceStatus.put("proType", deviceType);
            deviceStatus.put("status", status);
            String deviceStatusString = JSON.toJSONString(deviceStatus);
            try {
                this.rocketMQUtils.send("sssb_device_status_message_topic", deviceStatusString);
            }
            catch (Exception e) {
                this.log.error("\u8bbe\u5907\u72b6\u6001\u53d1\u9001\u5931\u8d25:{}", (Throwable)e);
            }
        } else {
            DeviceStatusLog newDeviceStatusLog = new DeviceStatusLog();
            newDeviceStatusLog.setDeviceCode(deviceCode);
            newDeviceStatusLog.setDeviceStatus(status);
            newDeviceStatusLog.setDeviceType(deviceType);
            newDeviceStatusLog.setStartTime(LocalDateTime.now());
            newDeviceStatusLog.setEndTime(LocalDateTime.of(9999, 12, 31, 23, 59, 59));
            this.statusLogDao.insert((Object)newDeviceStatusLog);
            HashMap<String, String> deviceStatus = new HashMap<String, String>();
            deviceStatus.put("deviceCode", deviceCode);
            deviceStatus.put("proType", deviceType);
            deviceStatus.put("status", status);
            String deviceStatusString = JSON.toJSONString(deviceStatus);
            try {
                this.rocketMQUtils.send("sssb_device_status_message_topic", deviceStatusString);
            }
            catch (Exception e) {
                this.log.error("\u8bbe\u5907\u72b6\u6001\u53d1\u9001\u5931\u8d25:{}", (Throwable)e);
            }
        }
        return null != result && result >= 1;
    }

    @Override
    public DeviceInfo findById(String id) {
        DeviceInfo deviceInfo = (DeviceInfo)((Object)((DeviceInfoDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null == deviceInfo) {
            return null;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"device_id_", (Object)id);
        List deviceParamsValues = this.paramsValueDao.selectList((Wrapper)queryWrapper);
        deviceInfo.setParamsValueList(deviceParamsValues);
        return deviceInfo;
    }

    @Override
    public PageList<DeviceInfo> findByProductType(QueryFilter<DeviceInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage<DeviceInfo> result = ((DeviceInfoDao)this.baseMapper).findByProductType((IPage<DeviceInfo>)this.convert2IPage(pageBean), (QueryWrapper<DeviceInfo>)this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(result);
    }

    @Override
    public DeviceInfo detail(String id) {
        DeviceBaseArea deviceBaseArea;
        DeviceBaseUser deviceBaseUser;
        DeviceBaseCompany deviceBaseCompany;
        DeviceInfo deviceInfo = (DeviceInfo)((Object)((DeviceInfoDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (null == deviceInfo) {
            return null;
        }
        DeviceProductInfo productInfo = (DeviceProductInfo)((Object)this.deviceProductInfoDao.selectById((Serializable)((Object)deviceInfo.getProductId())));
        if (null != productInfo) {
            deviceInfo.setProductName(productInfo.getName());
        }
        if (null != (deviceBaseCompany = (DeviceBaseCompany)((Object)this.companyDao.selectById((Serializable)((Object)deviceInfo.getSupplierCompanyId()))))) {
            deviceInfo.setCompanyName(deviceBaseCompany.getCompanyName());
        }
        if (null != (deviceBaseUser = (DeviceBaseUser)((Object)this.deviceBaseUserDao.selectById((Serializable)((Object)deviceInfo.getManagerUserId()))))) {
            deviceInfo.setManagerUserName(deviceBaseUser.getName());
        }
        if (null != (deviceBaseUser = (DeviceBaseUser)((Object)this.deviceBaseUserDao.selectById((Serializable)((Object)deviceInfo.getRepairUserId()))))) {
            deviceInfo.setRepairUserName(deviceBaseUser.getName());
        }
        if (null != (deviceBaseArea = (DeviceBaseArea)((Object)this.areaDao.selectById((Serializable)((Object)deviceInfo.getAreaId()))))) {
            deviceInfo.setAreaName(deviceBaseArea.getName());
        }
        String addressName = ((DeviceInfoDao)this.baseMapper).getAreaName(deviceInfo.getAddvcd());
        deviceInfo.setAddressName(addressName);
        return deviceInfo;
    }

    @Override
    public List<CountVo> statistics(String productType) {
        List<DeviceInfo> deviceInfos = ((DeviceInfoDao)this.baseMapper).findDeviceList(productType);
        Map<String, List<DeviceInfo>> deviceMap = deviceInfos.stream().filter(base -> !StringUtils.isEmpty((Object)base.getStatus())).collect(Collectors.groupingBy(DeviceInfo::getStatus));
        ArrayList data = Lists.newArrayList();
        for (DeviceStatusEnum type : DeviceStatusEnum.values()) {
            CountVo countVo = new CountVo();
            if (deviceMap.containsKey(type.getType())) {
                countVo.setCount(deviceMap.get(type.getType()).size());
            } else {
                countVo.setCount(0);
            }
            countVo.setStatusName(type.getDesc());
            data.add(countVo);
        }
        Integer warnCount = this.warnInfoManager.findByDeviceType(ProductTypeEnum.getType((String)productType));
        CountVo countVo = new CountVo();
        countVo.setCount(warnCount);
        countVo.setStatusName("\u544a\u8b66\u6570");
        data.add(countVo);
        return data;
    }

    @Override
    public PageList<FailureDeviceCountVo> failureStatistics(QueryFilter<DeviceInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage<FailureDeviceCountVo> result = ((DeviceInfoDao)this.baseMapper).failureStatistics((IPage<DeviceInfo>)this.convert2IPage(pageBean), (QueryWrapper<DeviceInfo>)this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(result);
    }

    @Override
    public PageList<DeviceInfo> findByPage(QueryFilter<DeviceInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage<DeviceInfo> result = ((DeviceInfoDao)this.baseMapper).findByPage((IPage<DeviceInfo>)this.convert2IPage(pageBean), (QueryWrapper<DeviceInfo>)this.convert2Wrapper(queryFilter, currentModelClass));
        return new PageList(result);
    }

    @Override
    public PageList<DeviceInfo> failureEquipment(QueryFilter<DeviceInfo> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        QueryWrapper wrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        wrapper.eq((Object)"dwi.WARN_TYPE_", (Object)"1");
        IPage<DeviceInfo> result = ((DeviceInfoDao)this.baseMapper).failureEquipment((IPage<DeviceInfo>)this.convert2IPage(pageBean), (QueryWrapper<DeviceInfo>)wrapper);
        return new PageList(result);
    }

    @Override
    public List<StatisticsVo> homeStatistics() {
        ArrayList result = Lists.newArrayList();
        List deviceStatus = this.sdm.queryDictListItemsByCode("sbzt");
        Map<String, List<DeviceInfo>> deviceInfos = this.list().stream().collect(Collectors.groupingBy(DeviceInfo::getStatus));
        List v = this.videoPointManager.list();
        Map<String, List<DeviceVideoPoint>> videoPoints = v.stream().collect(Collectors.groupingBy(DeviceVideoPoint::getStatus));
        Integer total = v.isEmpty() ? 0 : v.size();
        for (Map.Entry<String, List<DeviceInfo>> d : deviceInfos.entrySet()) {
            StatisticsVo dTemp = new StatisticsVo();
            dTemp.setStatus(BizUtils.getDicValueByCode(deviceStatus, d.getKey()));
            dTemp.setCount(d.getValue().size());
            result.add(dTemp);
            total = total + d.getValue().size();
        }
        result.forEach(r -> {
            if ("\u6b63\u5e38".equals(r.getStatus()) && BeanUtils.isNotEmpty(videoPoints.get("1"))) {
                r.setCount(r.getCount() + ((List)videoPoints.get("1")).size());
            }
            if ("\u6545\u969c".equals(r.getStatus()) && BeanUtils.isNotEmpty(videoPoints.get("0"))) {
                r.setCount(r.getCount() + ((List)videoPoints.get("0")).size());
            }
        });
        result.add(new StatisticsVo("\u603b\u6570", total));
        return result;
    }

    @Override
    public List<StatisticsVo> currentStatusAnalyze() {
        ArrayList result = Lists.newArrayList();
        List deviceStatus = this.sdm.queryDictListItemsByCode("sbzt");
        List videostatus = this.sdm.queryDictListItemsByCode("spdwzt");
        Map<String, Map<String, List<DeviceInfo>>> data = ((DeviceInfoDao)this.baseMapper).currentStatusAnalyze().stream().collect(Collectors.groupingBy(DeviceInfo::getName, Collectors.groupingBy(DeviceInfo::getStatus)));
        for (Map.Entry<String, Map<String, List<DeviceInfo>>> d : data.entrySet()) {
            StatisticsVo dTemp = new StatisticsVo(d.getKey());
            ArrayList subData = Lists.newArrayList();
            boolean isVideo = "\u6444\u50cf\u5934".equals(d.getKey());
            if (isVideo) {
                d.setValue(BizUtils.sortByKey(d.getValue(), true));
            }
            for (Map.Entry<String, List<DeviceInfo>> s : d.getValue().entrySet()) {
                String status = BizUtils.getDicValueByCode(isVideo ? videostatus : deviceStatus, s.getKey());
                subData.add(new StatisticsVo(status, s.getValue().size()));
            }
            dTemp.setData(subData);
            result.add(dTemp);
        }
        return result;
    }

    @Override
    public List<StatisticsVo> monthlyAnalyze(String code) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)code), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List deviceStatus = this.sdm.queryDictListItemsByCode("sbzt");
        List videostatus = this.sdm.queryDictListItemsByCode("spdwzt");
        List<Object> result = Lists.newArrayList();
        Map<String, Map<String, List<StatisticsVo>>> data = ("video".equals(code) ? ((DeviceInfoDao)this.baseMapper).monthlyVideoAnalyze() : ((DeviceInfoDao)this.baseMapper).monthlyAnalyze(code)).stream().collect(Collectors.groupingBy(StatisticsVo::getTime, Collectors.groupingBy(StatisticsVo::getStatus)));
        for (Map.Entry<String, Map<String, List<StatisticsVo>>> d : data.entrySet()) {
            ArrayList statusData = Lists.newArrayList();
            for (Map.Entry<String, List<StatisticsVo>> s : d.getValue().entrySet()) {
                String status = BizUtils.getDicValueByCode("video".equals(code) ? videostatus : deviceStatus, s.getKey());
                statusData.add(new StatisticsVo(status, s.getValue().size()));
            }
            result.add(new StatisticsVo(d.getKey(), statusData));
        }
        for (int i = 0; i <= 31; ++i) {
            String date = DateUtils.formatSubDayDate((int)i);
            if (result.stream().filter(r -> r.getTime().equals(date)).findAny().isPresent()) continue;
            result.add(new StatisticsVo(date, Lists.newArrayList()));
        }
        result = result.stream().sorted(Comparator.comparing(StatisticsVo::getTime)).collect(Collectors.toList());
        return result;
    }

    @Override
    public List<HomeRealTimeVo> homeRealTime(String code) {
        String table = ProductTypeEnum.getTable((String)code);
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)table), (String)"\u975e\u6cd5 code\uff01");
        return ((DeviceInfoDao)this.baseMapper).homeRealTime(table, code);
    }
}

