/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.third.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.conf.DingdingConfig;
import com.artfess.base.dingding.utils.AccessTokenUtil;
import com.artfess.base.dingding.utils.DingCallbackCrypto;
import com.artfess.base.model.CommonResult;
import com.artfess.third.service.DingdingService;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiV2DepartmentCreateRequest;
import com.dingtalk.api.request.OapiV2DepartmentListsubRequest;
import com.dingtalk.api.request.OapiV2DepartmentUpdateRequest;
import com.dingtalk.api.request.OapiV2UserCreateRequest;
import com.dingtalk.api.request.OapiV2UserUpdateRequest;
import com.dingtalk.api.response.OapiV2DepartmentCreateResponse;
import com.dingtalk.api.response.OapiV2DepartmentListsubResponse;
import com.dingtalk.api.response.OapiV2DepartmentUpdateResponse;
import com.dingtalk.api.response.OapiV2UserCreateResponse;
import com.dingtalk.api.response.OapiV2UserUpdateResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import io.swagger.annotations.Api;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u9489\u9489"})
@RequestMapping(value={"/api/dingding/"})
@ApiGroup(group={"device_biz"})
public class DingdingController {
    private static final Logger log = LoggerFactory.getLogger(DingdingController.class);
    @Autowired
    private DingdingService dingdingService;
    @Autowired
    private DingdingConfig dingdingConfig;

    @GetMapping(value={"/config"})
    public CommonResult<String> getDingTalkConfig() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("corpId", this.dingdingConfig.getCorpId());
        return CommonResult.success(configMap, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @GetMapping(value={"/login"})
    public CommonResult<String> login(@RequestParam(value="authCode") String authCode) {
        return CommonResult.success((Object)this.dingdingService.getUserInfo(authCode), (String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u6210\u529f");
    }

    @PostMapping(value={"/callBack"})
    public Map<String, String> callBack(@RequestParam(value="msg_signature", required=false) String msg_signature, @RequestParam(value="timestamp", required=false) String timeStamp, @RequestParam(value="nonce", required=false) String nonce, @RequestBody(required=false) JSONObject json) {
        try {
            log.info("------------------------");
            DingCallbackCrypto callbackCrypto = new DingCallbackCrypto(this.dingdingConfig.getToken(), this.dingdingConfig.getAeskey(), this.dingdingConfig.getAppKey());
            String encryptMsg = json.getString("encrypt");
            String decryptMsg = callbackCrypto.getDecryptMsg(msg_signature, timeStamp, nonce, encryptMsg);
            JSONObject eventJson = JSON.parseObject((String)decryptMsg);
            log.info("\u56de\u8c03\u4e8b\u4ef6\u54cd\u5e94\u6570\u636e:{}", (Object)eventJson);
            String eventType = eventJson.getString("EventType");
            if ("check_url".equals(eventType)) {
                log.info("\u6d4b\u8bd5\u56de\u8c03url\u7684\u6b63\u786e\u6027");
            } else if ("user_add_org".equals(eventType)) {
                log.info("\u53d1\u751f\u4e86\uff1a" + eventType + "\u4e8b\u4ef6");
            } else {
                log.info("\u53d1\u751f\u4e86\uff1a" + eventType + "\u4e8b\u4ef6");
            }
            Map successMap = callbackCrypto.getEncryptedMap("success");
            return successMap;
        }
        catch (DingCallbackCrypto.DingTalkEncryptException e) {
            e.printStackTrace();
            return null;
        }
    }

    @PostMapping(value={"/createUser"})
    public OapiV2UserCreateResponse createDingdingUser(@RequestBody OapiV2UserCreateRequest dingdingUser) throws ApiException {
        String accessToken = AccessTokenUtil.getAccessToken((String)this.dingdingConfig.getAppKey(), (String)this.dingdingConfig.getAppSecret());
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/create");
        OapiV2UserCreateResponse rsp = (OapiV2UserCreateResponse)client.execute((TaobaoRequest)dingdingUser, accessToken);
        log.info("\u521b\u5efa\u7528\u6237\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)rsp));
        return rsp;
    }

    @PostMapping(value={"/updateUser"})
    public OapiV2UserUpdateResponse updateUser(@RequestBody OapiV2UserUpdateRequest req) throws ApiException {
        String accessToken = AccessTokenUtil.getAccessToken((String)this.dingdingConfig.getAppKey(), (String)this.dingdingConfig.getAppSecret());
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/update");
        OapiV2UserUpdateResponse rsp = (OapiV2UserUpdateResponse)client.execute((TaobaoRequest)req, accessToken);
        log.info("\u66f4\u65b0\u7528\u6237\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)rsp));
        return rsp;
    }

    @PostMapping(value={"/createDept"})
    public OapiV2DepartmentCreateResponse createDept(@RequestBody OapiV2DepartmentCreateRequest req) throws ApiException {
        String accessToken = AccessTokenUtil.getAccessToken((String)this.dingdingConfig.getAppKey(), (String)this.dingdingConfig.getAppSecret());
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/create");
        OapiV2DepartmentCreateResponse rsp = (OapiV2DepartmentCreateResponse)client.execute((TaobaoRequest)req, accessToken);
        log.info("\u521b\u5efa\u90e8\u95e8\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)rsp));
        return rsp;
    }

    @PostMapping(value={"/updateDept"})
    public OapiV2DepartmentUpdateResponse createDingdingUser(@RequestBody OapiV2DepartmentUpdateRequest req) throws ApiException {
        String accessToken = AccessTokenUtil.getAccessToken((String)this.dingdingConfig.getAppKey(), (String)this.dingdingConfig.getAppSecret());
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/update");
        OapiV2DepartmentUpdateResponse rsp = (OapiV2DepartmentUpdateResponse)client.execute((TaobaoRequest)req, accessToken);
        log.info("\u66f4\u65b0\u90e8\u95e8\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)rsp));
        return rsp;
    }

    @PostMapping(value={"/deptList"})
    public OapiV2DepartmentListsubResponse deptList(@RequestBody OapiV2DepartmentListsubRequest req) throws ApiException {
        String accessToken = AccessTokenUtil.getAccessToken((String)this.dingdingConfig.getAppKey(), (String)this.dingdingConfig.getAppSecret());
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
        OapiV2DepartmentListsubResponse rsp = (OapiV2DepartmentListsubResponse)client.execute((TaobaoRequest)req, accessToken);
        req.setDeptId(Long.valueOf(1L));
        req.setLanguage("zh_CN");
        log.info("\u90e8\u95e8\u5217\u8868\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)rsp));
        return rsp;
    }
}

