/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.exception;

import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice(basePackages={"com.artfess.device"})
public class VaildExceptionControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(VaildExceptionControllerAdvice.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public CommonResult handleValidException(MethodArgumentNotValidException e) {
        log.error("\u6570\u636e\u6821\u9a8c\u51fa\u73b0\u95ee\u9898{}, \u5f02\u5e38\u7c7b\u578b:{}", (Object)e.getMessage(), e.getClass());
        BindingResult result = e.getBindingResult();
        HashMap errorMap = new HashMap();
        result.getFieldErrors().forEach(item -> errorMap.put(item.getField(), item.getDefaultMessage()));
        return new CommonResult(ResponseErrorEnums.REQUIRED_ERROR, errorMap);
    }
}

