/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.manager.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialQuantityDao;
import com.artfess.manage.material.dao.CmgtMaterialWarehouseInoutDao;
import com.artfess.manage.material.dao.CmgtMaterialWarehouseInoutDetailDao;
import com.artfess.manage.material.manager.CmgtMaterialInfoManager;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutManager;
import com.artfess.manage.material.model.CmgtMaterialInfo;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInout;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInoutDetail;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.exception.BadRequestException;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmgtMaterialWarehouseInoutManagerImpl
extends BaseManagerImpl<CmgtMaterialWarehouseInoutDao, CmgtMaterialWarehouseInout>
implements CmgtMaterialWarehouseInoutManager {
    @Resource
    private CmgtMaterialQuantityManage quantityManage;
    @Resource
    private CmgtMaterialQuantityDao quantityDao;
    @Resource
    private CmgtMaterialInfoManager materialInfoManager;
    @Resource
    private CmgtMaterialWarehouseInoutDetailManager warehouseInoutDetailManager;
    @Resource
    private CmgtMaterialWarehouseInoutDao warehouseInoutDao;
    @Resource
    private CmgtMaterialWarehouseInoutDetailDao cmgtMaterialWarehouseInoutDetailDao;
    @Resource
    SysIdentityManager sysIdentityManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean createInout(CmgtMaterialWarehouseInout t) {
        t.getDetailList().forEach(d -> {
            d.setWarehouse(t.getWarehouse());
            d.setOrgId(t.getOrgId());
            d.setApplicant(t.getApplicant());
            d.setInoutDate(t.getInoutDate());
            d.setSupplier(t.getSource());
            d.setStatus(t.getStatus());
        });
        boolean result = false;
        if ("0".equals(t.getDataType())) {
            result = this.save((Object)t);
            ArrayList<CmgtMaterialWarehouseInoutDetail> dlist = new ArrayList<CmgtMaterialWarehouseInoutDetail>();
            t.getDetailList().forEach(d -> {
                d.setWarehouseInoutId(t.getId());
                dlist.add((CmgtMaterialWarehouseInoutDetail)((Object)d));
            });
            this.warehouseInoutDetailManager.saveBatch(dlist);
            if ("COMPLETED".equals(t.getStatus())) {
                this.addQuantity(dlist, t.getWarehouse());
            }
            return result;
        }
        if ("1".equals(t.getDataType())) {
            result = this.save((Object)t);
            ArrayList<CmgtMaterialWarehouseInoutDetail> dlist = new ArrayList<CmgtMaterialWarehouseInoutDetail>();
            t.getDetailList().forEach(d -> {
                d.setWarehouseInoutId(t.getId());
                dlist.add((CmgtMaterialWarehouseInoutDetail)((Object)d));
            });
            this.warehouseInoutDetailManager.saveBatch(dlist);
            if ("COMPLETED".equals(t.getStatus())) {
                this.commitCK(dlist);
            }
            return result;
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateInout(CmgtMaterialWarehouseInout t) {
        t.getDetailList().forEach(d -> {
            d.setWarehouse(t.getWarehouse());
            d.setOrgId(t.getOrgId());
            d.setApplicant(t.getApplicant());
            d.setApplicantId(t.getApplicantId());
            d.setInoutDate(t.getInoutDate());
            d.setStatus(t.getStatus());
        });
        boolean res = false;
        if (t.getDataType().equals("0")) {
            res = this.updateById((Object)t);
            this.delteDetail(t.getId());
            ArrayList dlist = new ArrayList();
            t.getDetailList().forEach(d -> {
                d.setWarehouseInoutId(t.getId());
                d.setId(null);
                dlist.add(d);
            });
            this.warehouseInoutDetailManager.saveBatch(dlist);
            if ("COMPLETED".equals(t.getStatus())) {
                this.addQuantity(t.getDetailList(), t.getWarehouse());
            }
            return res;
        }
        if (t.getDataType().equals("1")) {
            res = this.updateById((Object)t);
            this.delteDetail(t.getId());
            ArrayList<CmgtMaterialWarehouseInoutDetail> dlist = new ArrayList<CmgtMaterialWarehouseInoutDetail>();
            t.getDetailList().forEach(d -> {
                d.setWarehouseInoutId(t.getId());
                d.setId(null);
                dlist.add((CmgtMaterialWarehouseInoutDetail)((Object)d));
            });
            this.warehouseInoutDetailManager.saveBatch(dlist);
            if ("COMPLETED".equals(t.getStatus())) {
                this.commitCK(dlist);
            }
            return res;
        }
        return res;
    }

    private void commitCK(List<CmgtMaterialWarehouseInoutDetail> dlist) {
        dlist.forEach(d -> {
            CmgtMaterialInfo m = (CmgtMaterialInfo)((Object)((Object)this.materialInfoManager.getById((Serializable)((Object)d.getMaterialInfoId()))));
            CmgtMaterialQuantity quantity = (CmgtMaterialQuantity)((Object)((Object)this.quantityManage.getById((Serializable)((Object)d.getDescription()))));
            d.setAvailableQuantity(quantity.getQuantity());
            if (d.getQuantity().doubleValue() > quantity.getQuantity().doubleValue()) {
                throw new BadRequestException("\u9886\u7528\u6570\u91cf\u8d85\u8fc7\u4e86\u5e93\u5b58\u6570\u91cf\uff01");
            }
            quantity.setQuantity(quantity.getQuantity().subtract(d.getQuantity()));
            this.quantityManage.updateById((Object)quantity);
            d.setAmount(new BigDecimal(0));
            List<CmgtMaterialWarehouseInoutDetail> rk = this.cmgtMaterialWarehouseInoutDetailDao.findRKDeatilsByQuantityId(quantity.getId());
            BigDecimal cksl = d.getQuantity();
            for (CmgtMaterialWarehouseInoutDetail r : rk) {
                if (r.getAvailableQuantity() == null || !(r.getAvailableQuantity().doubleValue() > 0.0)) continue;
                if (r.getAvailableQuantity().doubleValue() >= cksl.doubleValue()) {
                    r.setAvailableQuantity(r.getAvailableQuantity().subtract(cksl));
                    this.warehouseInoutDetailManager.updateById((Object)r);
                    d.setPrice(r.getPrice());
                    d.setUnit(r.getUnit());
                    d.setModel(r.getModel());
                    d.setAmount(d.getAmount().add(cksl.multiply(r.getPrice())));
                    break;
                }
                d.setAmount(d.getAmount().add(r.getAvailableQuantity().multiply(r.getPrice())));
                cksl = cksl.subtract(r.getAvailableQuantity());
                r.setAvailableQuantity(new BigDecimal(0));
                this.warehouseInoutDetailManager.updateById((Object)r);
            }
            d.setQuantityId(quantity.getId());
            this.warehouseInoutDetailManager.updateById(d);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addQuantity(List<CmgtMaterialWarehouseInoutDetail> dlist, String warehouse) {
        dlist.forEach(d -> {
            CmgtMaterialQuantity quantity = this.quantityDao.findByMidAndWarhouse(d.getMaterialInfoId(), warehouse);
            CmgtMaterialInfo m = (CmgtMaterialInfo)((Object)((Object)this.materialInfoManager.getById((Serializable)((Object)d.getMaterialInfoId()))));
            if (quantity != null && quantity.getId() != null) {
                quantity.setQuantity(quantity.getQuantity().add(d.getQuantity()));
                quantity.setAmount(quantity.getAmount() != null ? quantity.getAmount().add(d.getAmount()) : d.getAmount());
                this.quantityManage.updateById((Object)quantity);
                d.setQuantityId(quantity.getId());
                d.setAvailableQuantity(d.getQuantity());
                this.warehouseInoutDetailManager.updateById(d);
            } else {
                CmgtMaterialQuantity q = new CmgtMaterialQuantity();
                q.setClassId(m.getClassId());
                q.setMid(d.getMaterialInfoId());
                q.setName(m.getName());
                q.setWarehouse(warehouse);
                q.setUnit(m.getUnit());
                q.setQuantity(d.getQuantity());
                q.setAmount(d.getAmount());
                this.quantityManage.save((Object)q);
                d.setQuantityId(q.getId());
                d.setAvailableQuantity(d.getQuantity());
                this.warehouseInoutDetailManager.updateById(d);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean subtractQuantity(String wid, String warehouse) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wid", wid);
        params.put("warehouse", warehouse);
        return this.warehouseInoutDao.subtractQuantity(params);
    }

    void delteDetail(String wid) {
        List<CmgtMaterialWarehouseInoutDetail> list = this.warehouseInoutDetailManager.findMaterialDetailById(wid);
        list.forEach(l -> this.warehouseInoutDetailManager.removeById((Serializable)((Object)l.getId())));
    }

    @Override
    public BigDecimal getQuantity(String wid, String mid, BigDecimal nowNum) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("wid", wid);
        params.put("qid", mid);
        params.put("nowNum", nowNum);
        return this.warehouseInoutDao.getQuantity(params);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean removeInoutById(String ... ids) {
        boolean result = false;
        for (String id : ids) {
            CmgtMaterialWarehouseInout t = (CmgtMaterialWarehouseInout)((Object)this.getById((Serializable)((Object)id)));
            if ("COMPLETED".equals(t.getStatus())) {
                throw new BadRequestException("\u5df2\u7ecf\u51fa\u5165\u5e93\u7684\u4fe1\u606f\u4e0d\u80fd\u88ab\u5220\u9664\uff01");
            }
            if ("0".equals(t.getDataType())) {
                this.subtractQuantity(t.getId(), t.getWarehouse());
            }
            if ("1".equals(t.getDataType())) {
                this.warehouseInoutDao.addQuantity(t.getId());
            }
            this.delteDetail(id);
            result = this.removeById((Serializable)((Object)id));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importRKData(List<Map<String, Object>> mdata) {
        ArrayList<CmgtMaterialWarehouseInout> rkds = new ArrayList<CmgtMaterialWarehouseInout>();
        for (Map<String, Object> m : mdata) {
            CmgtMaterialWarehouseInout warehouseInout = (CmgtMaterialWarehouseInout)((Object)JSONUtil.toBean((JSONObject)JSONUtil.parseObj(m), CmgtMaterialWarehouseInout.class));
            if (warehouseInout.getSource() == null) {
                warehouseInout.setSource("\u672a\u77e5");
            }
            String gys = warehouseInout.getSource();
            List exRkd = rkds.stream().filter(e -> e.getSource().equals(gys)).collect(Collectors.toList());
            if (exRkd.size() > 0) {
                warehouseInout = (CmgtMaterialWarehouseInout)((Object)exRkd.get(0));
            } else {
                warehouseInout.setDetailList(new ArrayList<CmgtMaterialWarehouseInoutDetail>());
                warehouseInout.setDataType("0");
                warehouseInout.setWarehouse("3");
                warehouseInout.setInoutDate(LocalDate.now());
                warehouseInout.setStatus("CREATED");
                warehouseInout.setMemo("\u5bfc\u5165\u521b\u5efa");
                warehouseInout.setSn(999);
                warehouseInout.setApplicant(ContextUtil.getCurrentUser().getFullname());
                warehouseInout.setOrgId(ContextUtil.getCurrentOrgId());
                warehouseInout.setOrg(ContextUtil.getCurrentOrgName());
                rkds.add(warehouseInout);
            }
            CmgtMaterialWarehouseInoutDetail detail = (CmgtMaterialWarehouseInoutDetail)((Object)JSONUtil.toBean((JSONObject)JSONUtil.parseObj(m), CmgtMaterialWarehouseInoutDetail.class));
            CmgtMaterialInfo materialInfo = this.materialInfoManager.getLikeName(detail.getName(), detail.getModel());
            if (materialInfo == null) {
                materialInfo = this.createMasterialInfo(detail);
            }
            detail.setMaterialInfoId(materialInfo.getId());
            detail.setName(materialInfo.getName());
            detail.setModel(materialInfo.getModel());
            detail.setUnit(materialInfo.getUnit());
            if (detail.getPrice() != null && detail.getQuantity() != null) {
                detail.setAmount(detail.getPrice().multiply(detail.getQuantity()));
            }
            warehouseInout.getDetailList().add(detail);
        }
        System.out.println("============rkds===========" + rkds);
        rkds.forEach(r -> this.createInout((CmgtMaterialWarehouseInout)((Object)r)));
    }

    private CmgtMaterialInfo createMasterialInfo(CmgtMaterialWarehouseInoutDetail detail) {
        CmgtMaterialInfo materialInfo = new CmgtMaterialInfo();
        materialInfo.setName(detail.getName());
        materialInfo.setModel(detail.getModel());
        materialInfo.setPrice(detail.getPrice());
        materialInfo.setUnit(detail.getUnit());
        materialInfo.setCode(this.sysIdentityManager.nextId("wzbh"));
        materialInfo.setMemo("\u5165\u5e93\u5bfc\u5165\u521b\u5efa");
        materialInfo.setSn(999);
        this.materialInfoManager.create((Model)materialInfo);
        return materialInfo;
    }
}

