/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.duty.manager.impl;

import cn.hutool.core.util.RandomUtil;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.duty.dao.CmgtDutyVehicleDao;
import com.artfess.manage.duty.dao.CmgtDutyVehicleGpsinfoDao;
import com.artfess.manage.duty.manager.CmgtDutyVehicleGpsinfoManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyVehicleGpsinfoDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyVehicleGpsinfoDtoMapper;
import com.artfess.manage.duty.model.CmgtDutyVehicle;
import com.artfess.manage.duty.model.CmgtDutyVehicleGpsinfo;
import com.artfess.manage.duty.model.TeamMemberStatusEnum;
import com.artfess.manage.utils.GeoUtils;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.exception.BadRequestException;
import com.artfess.uc.model.User;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmgtDutyVehicleGpsinfoManagerImpl
extends BaseManagerImpl<CmgtDutyVehicleGpsinfoDao, CmgtDutyVehicleGpsinfo>
implements CmgtDutyVehicleGpsinfoManager {
    @Resource
    private UserDao userDao;
    @Resource
    private CmgtDutyVehicleGpsinfoDao cmgtDutyVehicleGpsinfoDao;
    @Resource
    private CmgtDutyVehicleDao cmgtDutyVehicleDao;
    @Resource
    private CmgtDutyVehicleGpsinfoDtoMapper cmgtDutyVehicleGpsinfoDtoMapper;
    @Resource
    private ManageCommonService manageCommonService;

    @Override
    public PageList<CmgtDutyVehicleGpsinfoDto> pageQuery(QueryFilter<CmgtDutyVehicleGpsinfo> queryFilter) {
        PageList result = this.query(queryFilter);
        PageList r = new PageList(result.getRows().stream().map(e -> {
            User user;
            CmgtDutyVehicleGpsinfoDto t = (CmgtDutyVehicleGpsinfoDto)((Object)((Object)this.cmgtDutyVehicleGpsinfoDtoMapper.toDto(e)));
            t.setVehicleIdName(this.manageCommonService.getfindSelectOptionsLabel("cmgtDutySelectOptions.getCmgtDutyVehicles", "value", "label", t.getVehicleId()));
            if (e.getCreateBy() != null && (user = (User)this.userDao.selectById((Serializable)((Object)e.getCreateBy()))) != null) {
                t.setCreateByName(user.getFullname());
            }
            return t;
        }).collect(Collectors.toList()));
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtDutyVehicleGpsinfo t) {
        if (t.getVehicleId() == null) {
            throw new BadRequestException("\u6240\u5c5e\u8f66\u8f86\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int i = ((CmgtDutyVehicleGpsinfoDao)this.baseMapper).insert((Object)t);
        CmgtDutyVehicle cmgtDutyVehicle = (CmgtDutyVehicle)((Object)this.cmgtDutyVehicleDao.selectById((Serializable)((Object)t.getVehicleId())));
        cmgtDutyVehicle.setLocation(t.getLatitude() + "," + t.getLongitude());
        cmgtDutyVehicle.setReceiveTime(t.getReceiveTime());
        if (cmgtDutyVehicle.getArea() != null && !GeoUtils.pointInPolygon(cmgtDutyVehicle.getLocation(), cmgtDutyVehicle.getArea())) {
            cmgtDutyVehicle.setStatus(TeamMemberStatusEnum.CROSSING.name());
        } else {
            cmgtDutyVehicle.setStatus(TeamMemberStatusEnum.ONLINE.name());
        }
        this.cmgtDutyVehicleDao.updateById((Object)cmgtDutyVehicle);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtDutyVehicleGpsinfo t) {
        if (t.getVehicleId() == null) {
            throw new BadRequestException("\u6240\u5c5e\u8f66\u8f86\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CmgtDutyVehicle cmgtDutyVehicle = (CmgtDutyVehicle)((Object)this.cmgtDutyVehicleDao.selectById((Serializable)((Object)t.getVehicleId())));
        cmgtDutyVehicle.setLocation(t.getLatitude() + "," + t.getLongitude());
        cmgtDutyVehicle.setReceiveTime(t.getReceiveTime());
        this.cmgtDutyVehicleDao.updateById((Object)cmgtDutyVehicle);
        ((CmgtDutyVehicleGpsinfoDao)this.baseMapper).updateById((Object)t);
        return t.getId();
    }

    @Override
    @Transactional
    public void createSumilatedGpsData() {
        List vehicles = this.cmgtDutyVehicleDao.selectList(null);
        int idx = RandomUtil.randomInt((int)0, (int)vehicles.size());
        CmgtDutyVehicleGpsinfo gpsinfo = new CmgtDutyVehicleGpsinfo();
        gpsinfo.setVehicleId(((CmgtDutyVehicle)((Object)vehicles.get(idx))).getId());
        gpsinfo.setReceiveTime(LocalDateTime.now());
        gpsinfo.setMemo("\u968f\u673a\u751f\u6210\u6a21\u62df\u6570\u636e");
        gpsinfo.setLatitude(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(106.537288), (BigDecimal)BigDecimal.valueOf(106.55633)) + "");
        gpsinfo.setLongitude(RandomUtil.randomBigDecimal((BigDecimal)BigDecimal.valueOf(29.606626), (BigDecimal)BigDecimal.valueOf(29.615619)) + "");
        this.createInfo(gpsinfo);
    }

    @Override
    public void deleteInfo(CmgtDutyVehicleGpsinfo t) {
        ((CmgtDutyVehicleGpsinfoDao)this.baseMapper).deleteById((Serializable)((Object)t.getId()));
    }

    @Override
    public String create(CmgtDutyVehicleGpsinfoDto dto) {
        CmgtDutyVehicleGpsinfo t = (CmgtDutyVehicleGpsinfo)((Object)this.cmgtDutyVehicleGpsinfoDtoMapper.toEntity(dto));
        int i = ((CmgtDutyVehicleGpsinfoDao)this.baseMapper).insert((Object)t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String update(CmgtDutyVehicleGpsinfoDto dto) {
        CmgtDutyVehicleGpsinfo t = (CmgtDutyVehicleGpsinfo)((Object)this.cmgtDutyVehicleGpsinfoDtoMapper.toEntity(dto));
        ((CmgtDutyVehicleGpsinfoDao)this.baseMapper).updateById((Object)t);
        return t.getId();
    }

    @Override
    public boolean delete(List<String> ids) {
        for (String id : ids) {
            int count = ((CmgtDutyVehicleGpsinfoDao)this.baseMapper).deleteById((Serializable)((Object)id));
            if (count != 0) continue;
            return false;
        }
        return true;
    }
}

