import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增安全责任书
  addCmgtSaftyLiability(data, cb) {
    req.post(portal + `/manager/cmgtSaftyLiability/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改安全责任书
  editCmgtSaftyLiability(data, cb) {
    req.put(portal + `/manager/cmgtSaftyLiability/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询安全责任书
  loadCmgtSaftyLiability(data, cb) {
    req.post(portal + `/manager/cmgtSaftyLiability/query`, data).then(res => {
      cb(res.data)
    })
  },
    // 隐患单位数据
  cmgtSaftyDangerCheckschemeDetail(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerUnit/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除安全责任书
  deleteCmgtSaftyLiability(data, cb) {
    req.remove(portal + `/manager/cmgtSaftyLiability/delete`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询
  getItemById(id, cb) {
    req.get(portal + `/manager/cmgtSaftyLiability/` + id).then(res => {
      cb(res.data)
    })
  },
}
