import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增安全隐患排查对象
  addCmgtSaftyDangerUnit(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerUnit/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改安全隐患排查对象
  editCmgtSaftyDangerUnit(data, cb) {
    req.put(portal + `/manager/cmgtSaftyDangerUnit/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询安全隐患排查对象
  loadCmgtSaftyDangerUnit(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerUnit/pageQuery`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除安全隐患排查对象
  deleteCmgtSaftyDangerUnit(data, cb) {
    req.remove(portal + `/manager/cmgtSaftyDangerUnit/`, data).then(res => {
      cb(res.data)
    })
  },
}
