import req from '@/request.js'
const portal = window.context.portal
export default {
  //获取组织
  getOrgData(cb) {
    req
      .get(portal + `/manager/cmgtDutyOrgWorkarrange/findAllOrgTree`)
      .then((res) => {
        cb(res.data)
      })
  },
  // 查询分类树
  loadAllClass(cb) {
    req.get(portal + `/manager/material/class/findAll`).then((res) => {
      cb(res.data)
    })
  },
  // 物资消耗图表
  getDepartmentalMaterial(data, cb) {
    let { parentId = '0', deptId = '', startDate = '', endDate = '' } = data
    req.post(portal + `/manager/material/class/stockAnalysis?parentId=${parentId}&deptId=${deptId}&startDate=${startDate}&endDate=${endDate}`).then((res) => {
      cb(res.data)
    })
  },
  // 成本分析-整体成本分析
  getOverallCostData(data, cb) {
    let { startDate = '', endDate = '' } = data
    req.post(portal + `/manager/material/class/totalAmount?startDate=${startDate}&endDate=${endDate}`).then((res) => {
      cb(res.data)
    })
  },
  // 成本分析-物资成本分析
  getMaterialCostData(data, cb) {
    let { parentId = '0', startDate = '', endDate = '' } = data
    req.post(portal + `/manager/material/class/classAmount?parentId=${parentId}&startDate=${startDate}&endDate=${endDate}`).then((res) => {
      cb(res.data)
    })
  },
  // 成本分析-部门物资成本分析
  getOrgChartData(data, cb) {
    let { parentId = '0', startDate = '', endDate = '' } = data
    req.post(portal + `/manager/material/class/deptAmount?parentId=${parentId}&startDate=${startDate}&endDate=${endDate}`).then((res) => {
      cb(res.data)
    })
  },
  // 成本分析-部门物资成本分析
  getTableData(data, cb) {
    req.post(portal + `/manager/material/quantity/stockInfoAnalysis`, data).then((res) => {
      cb(res.data)
    })
  },
}
