import req from '@/request.js'
import qs from 'qs'

const portal = window.context.portal
export default {
  // 查询物资分类
  findMaterialClass(data, cb) {
    req.get(portal + `/manager/dingding/material/findClass?` + qs.stringify(data, {
      indices: false
    })).then(res => {
      cb(res.data)
    })
  },

  // 物资库存列表
  inventoryQuery(data) {
    return req.post(portal + `/manager/material/quantity/inventoryQuery`, data)
  },

  // 分页查询安全隐患排查记录
  loadCmgtSaftyDangerCheckrecord(data, cb) {
    return req.post(portal + `/manager/cmgtSaftyDangerCheckrecord/query`, data)
  }
}
