import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增安全培训计划
  addCmgtSaftyTrainingPlan(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTrainPlan/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改安全培训计划
  editCmgtSaftyTrainingPlan(data, cb) {
    req.put(portal + `/manager/cmgtSaftyTrainPlan/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询安全培训计划
  loadCmgtSaftyTrainingPlan(data, cb) {
    req.post(portal + `/manager/cmgtSaftyTrainPlan/query`, data).then(res => {
      cb(res.data)
    })
  },
    // 根据id查询实体
  cmgtSaftyTrainPlanId(data, cb) {
    req.get(portal + `/manager/cmgtSaftyTrainPlan/`+data).then(res => {
      cb(res.data)
    })
  },
    // 考评人
  getAllUser(cb) {
    req.get(portal + `/api/user/v1/users/getAllUser`).then(res => {
      cb(res.data)
    })
  },
    // 参与单位
  cmgtSaftyDangerUnit(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerUnit/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除安全培训计划
        deleteCmgtSaftyTrainingPlan(data) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/manager/cmgtSaftyTrainPlan/delete?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
}
