import req from '@/request.js'

const portal = window.context.portal
export default {
  // 新增
  addCmgtSaftyDangerUnit(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerUnit/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改
  editCmgtSaftyDangerUnit(data, cb) {
    req.put(portal + `/manager/cmgtSaftyDangerUnit/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询
  loadCmgtSaftyDangerUnit(data) {
    return req.post(portal + `/manager/cmgtSaftyDangerUnit/query`, data)
  },
  // 批量删除
  deleteCmgtSaftyDangerUnit(data, cb) {
    req.remove(portal + `/manager/cmgtSaftyDangerUnit/delete`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询
  getItemById(id, cb) {
    req.get(portal + `/manager/cmgtSaftyDangerUnit/` + id).then(res => {
      cb(res.data)
    })
  },
  // 根据分类查询统计数据
  getStatisticsData(type,cb) {
    req.get(portal + `/manager/cmgtSaftyDangerUnit/countSafetyArea?type=${type}`).then(res => {
      cb(res.data)
    })
  }
}
