import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增安全隐患排查计划
  addCmgtSaftyDangerCheckplan(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckplan/create`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改安全隐患排查计划
  editCmgtSaftyDangerCheckplan(data, cb) {
    req.put(portal + `/manager/cmgtSaftyDangerCheckplan/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询安全隐患排查计划
  loadCmgtSaftyDangerCheckplan(data, cb) {
    req.post(portal + `/manager/cmgtSaftyDangerCheckplan/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除安全隐患排查计划
  deleteCmgtSaftyDangerCheckplan(data, cb) {
    req.remove(portal + `/manager/cmgtSaftyDangerCheckplan/delete`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询
  getItemById(id, cb) {
    req.get(portal + `/manager/cmgtSaftyDangerCheckplan/` + id).then(res => {
      cb(res.data)
    })
  },
  // loadAllUnit(cb) {
  //   req.post(portal + `/manager/cmgtSaftyDangerCheckplan/findAllUnit`).then(res => {
  //     cb(res.data)
  //   })
  // },
}
