import req from '@/request.js'
const portal = window.context.portal
export default {
  // 新增基础位置信息
  addCmgtBasePosition(data, cb) {
    req.post(portal + `/manager/cmgtBasePosition/`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改基础位置信息
  editCmgtBasePosition(data, cb) {
    req.put(portal + `/manager/cmgtBasePosition/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询基础位置信息
  loadCmgtBasePosition(data, cb) {
    req.post(portal + `/manager/cmgtBasePosition/pageQuery`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除基础位置信息
  deleteCmgtBasePosition(data, cb) {
    req.remove(portal + `/manager/cmgtBasePosition/delete`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id查询机构信息
  getCmgtBasePositionByID(id, cb) {
    req.get(portal + `/manager/cmgtBasePosition/` + id).then(res => {
      cb(res.data)
    })
  },
}
