import req from '@/request.js'
import moment from 'moment'
export const TableMixin = {
  data() {
    return {
      portal: window.context.portal,
      loading: false,
      tableMaxHeight: 600,
      showMore: false,
      tableData: [],
      multipleSelection: [], // 复选框
      total: 0,
      queryParam: {
        pageBean: {
          pageSize: 20,
          page: 1
        },
        params: {},
        querys: []
      },
      isAdvanced: false
    }
  },
  mounted() {
    this.loadData()
    this.calcTableHeight()
    this.$root.$on('resize', () => {
      this.calcTableHeight(500)
    })
  },
  methods: {
    loadData() {
    },

    handleAdd() {
      this.$refs.formModal.add()
    },
    handleUpdate(row) {
      this.$refs.formModal.edit(row)
    },
    handleDelete() {
      // 批量删除
      req.remove(this.portal + this.url.delete + '?ids=' + this.multipleSelection).then(res => {
        this.$notify({
          type: 'success',
          message: '删除成功',
          duration: 2000
        })
        this.loadData()
        this.handleDeleteAfter && this.handleDeleteAfter()
      })
    },
    handleDbClick(row, column, event) {
      this.handleUpdate(row)
    },
    handleReset() {
      if (this.isAdvanced) {
        this.advanced()
      }
      this.queryParam.params = {}
      this.queryParam.querys = []
      this.clearQuerys && this.clearQuerys()
      this.handleSearch()
    },
    handleSearch() {
      this.queryParam.pageBean.page = 1
      this.loadData()
    },
    handleSizeChange(val) {
      this.queryParam.pageBean.pageSize = val
      this.loadData(1)
    },
    handleCurrentChange(val) {
      this.queryParam.pageBean.page = val
      this.loadData()
    },
    handleSelectionChange(val) {
      this.multipleSelection = [...new Set(val.map(({id}) => id))]
      console.log(this.multipleSelection)
    },
    commonPageClick() {
      if (this.showMore) {
        this.showMore = false
      }
    },
    // 展开高级搜索
    advanced() {
      this.isAdvanced = !this.isAdvanced
      this.$nextTick(() => {
          this.calcTableHeight(500)
      })
  },
    calcTableHeight(delay) {

      // 动态计算表格的高度，自适应当前容器
      setTimeout(() => {
        this.$nextTick(() => {
          if (!this.$refs.contentPanel) {
            return
          }
          const contentPanelHeight = (this.$refs.contentPanel && this.$refs.contentPanel.clientHeight) || 0
          const btnPanelHeight = (this.$refs.btnPanel && this.$refs.btnPanel.clientHeight) || 0
          const paginationPanelHeight = this.$refs.paginationPanel ? 32 : 0
          // (this.$refs.paginationPanel &&
          //     this.$refs.paginationPanel.clientHeight) ||
          // 0;
          this.tableMaxHeight =
            contentPanelHeight -
            btnPanelHeight -
            paginationPanelHeight - 42
        })

      }, delay || 0)
    },
    // 格式化时间
    formatDate(date) {
      return date ? moment(date).format('YYYY-MM-DD') : ''
    }
  }
}
