import req from '@/request.js'

const portal = window.context.portal
export default {
  /*防爆路障 实时监测 */
  // 分页查询
  loadQuery(data, cb) {
    req.post(portal + `/data/barricade/query`, data).then(res => {
      cb(res.data)
    })
  },
  /*防爆路障 路障设备 */
  // 分页查询
  loadBarricade(data, cb) {
    req.post(portal + `/device/info/findByProductType`, data).then(res => {
      cb(res.data || [])
    })
  },
  // 操作路障
  operationBarricade(data, cb) {
    req.post(portal + `/data/barricade/batchAct`, data).then(res => {
      cb(res.data)
    })
  },
  //锁定解锁
  lockDataLine(data, cb) {
    req.post(portal + `/data/barricade/lockAct`, data).then(res => {
      cb(res.data)
    })
  }

}
