import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 获取巡检台账表格数据
export function tableData(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionMaintenance/v1/findByPage`, data)
      .then(res => resolve(res.data))
      .catch(err => reject(err))
  })
}

// 获取工单信息详情
export function workOrderDetails(id = '') {
  return new Promise((resolve, reject) => {
    req.get(portal + `/deviceInspectionMaintenance/v1/checkDetails?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 工单扭转
export function workOrderReversal(data) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/deviceInspectionMaintenance/v1/edit`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}






