import req from '@/request.js'
const portal = window.context.portal
export default {
  // 获取单位供应商
  getSupplier(data, cb) {
    req.post(portal + `/device/base/company/findAll`, data).then(res => {
      cb(res.data)
    })
  },
  // 获取产品
  getProduct(data, cb) {
    req.post(portal + `/device/product/info/findAll`, data).then(res => {
      cb(res.data)
    })
  },
  // 获取产品分类
  getProductTree(data, cb) {
    req.post(portal + `/device/product/type/getTree`, data).then(res => {
      cb(res.data)
    })
  },
  // 获取设备列表
  deviceInfo(data, cb) {
    req.post(portal + `/device/info/findAll`, data).then(res => {
      cb(res.data)
    })
  },
  // 保存关联设备
  save(data, cb) {
    req.post(portal + `/device/relation/contract/bindDevice`, data).then(res => {
      cb(res.data)
    })
  },
  // 修改关联设备
  updated(data, cb) {
    req.post(portal + `/device/relation/contract/`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询合同关联设备
  loadContract(data, cb) {
    req.post(portal + `/device/relation/contract/findByPage`, data).then(res => {
      cb(res.data)
    })
  },
  // 查询合同已关联设备
  getDeviceList(data, cb) {
    req.post(portal + `/device/relation/contract/getDeviceList`, data).then(res => {
      cb(res.data)
    })
  },
  AllproductType(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/type/getAllTree`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
}