import req from '@/request.js'
const portal = window.context.portal
export default {
  // 获取分组列表数据
  typeList(data, cb) {
    req.post(portal + '/device/product/type/query', data).then(rep => {
      if (rep.data) {
        cb(rep.data)
      }
    })
  },
  // 新增数据
  addType(data, cb) {
    req.post(portal + '/device/product/type/', data).then(rep => {
      if (rep.data) {
        cb(rep.data)
      }
    })
  },
  // 修改数据
  updateType(data, cb) {
    req.put(portal + '/device/product/type/', data).then(rep => {
      if (rep.data) {
        cb(rep.data)
      }
    })
  },
  // 获取产品分类列表树
  productType(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/type/getTree`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  AllproductType(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/type/getAllTree`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 删除产品类型
  removeProductType(ids) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/device/product/type/?ids=` + ids).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
}