import req from '@/request.js'
const portal = window.context.portal
export default {
  // 获取产品分类
  productType(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/type/getTree`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
    // 获取产品分类
  getProductTree(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/type/getProductTree`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 新增产品类型
  addProductType(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/type/`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 删除产品类型
  removeProductType(ids) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/device/product/type/?ids=` + ids).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 更新产品类型
  updateProductType(data) {
    return new Promise((resolve, reject) => {
      req.put(portal + `/device/product/type/`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 根据id查询产品类型
  productTypeDetail(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/device/product/type/` + id).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 获取产品信息
  productInfo(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/info/query`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 新增产品信息
  addProductInfo(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/info/`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 更新产品信息
  updateProductInfo(data) {
    return new Promise((resolve, reject) => {
      req.put(portal + `/device/product/info/`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 批量删除产品信息
  removeProductInfo(ids) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/device/product/info/?ids=` + ids).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 根据id查询产品信息
  productInfoDetail(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/device/product/info/` + id).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 根据产品id发布产品
  productPublish(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/info/publish`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 获取产品扩展信息
  getExtend(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/product/paramsConf/findAll`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  }
}
