import req from '@/request.js'
// const portal = window.context.testHealth
const portal = window.context.portal
export default {
  // /* 性能分析 --->  故障统计 */
  //获取统计次数
  getCount(data, cb) {
    req.post(portal + `/device/data/failureStatistics`, data).then(res => {
      res && cb(res.data)
    })
  },
  //根据设备类型统计分析
  deviceType(productType) {
    req.get(portal + `/device/data/statistics/` + productType).then(res => {
     res
    })
  },
  // /* 性能分析 --->  时长统计 */
  //获取设备时长
  loadTime(data, cb) {
    req.post(portal + `/device/data/timeStatistics`, data).then(res => {
      res && cb(res.data)
    })
  },
  // /* 性能分析 --->  健康统计 */
  //## 设备状态统计
  getAnalysis(data, cb) {
    req.post(portal + `/performanceAnalysis/v1/statistics`, data).then(res => {
      res && cb(res.data)
    })
  },
  //## 设备故障次数统计
  getTrouble(data, cb) {
    req.post(portal + `/performanceAnalysis/v1/statisticsTrouble`, data).then(res => {
      res && cb(res.data)
    })
  },
  //## 当前设备故障次数统计
  getCurrentTrouble(data, cb) {
    req.post(portal + `/performanceAnalysis/v1/statisticsCurrentTrouble`, data).then(res => {
      res && cb(res.data)
    })
  },
  //## 各月份设备故障次数统计
  getDeviceCount(data, cb) {
    req.post(portal + `/performanceAnalysis/v1/troubleCountMonthly`, data).then(res => {
      res && cb(res.data)
    })
  },
  //## 设备告警次数统计
  getWarn(data, cb) {
    req.post(portal + `/performanceAnalysis/v1/statisticsWarn`, data).then(res => {
      res && cb(res.data)
    })
  },
  //## 当前设备告警次数统计
  getwarnCount(data, cb) {
    req.post(portal + `/performanceAnalysis/v1/warnCountCurrently`, data).then(res => {
      res && cb(res.data)
    })
  },
  //## 各月份设备告警次数统计
  getCountMonthly(data, cb) {
    req.post(portal + `/performanceAnalysis/v1/warnCountMonthly`, data).then(res => {
      res && cb(res.data)
    })
  },
  // 设备状态统计·下钻
  getStatisticsSub(data, cb) {
    req.post(portal + `/performanceAnalysis/v1/statisticsSub`, data).then(res => {
      res && cb(res.data)
    })
  }
}