import req from '@/request.js'
const portal = window.context.portal
export default {
  // 合同信息查询
  contractQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/base/contract/query`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 新增合同信息
  addContract(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/base/contract/saveContract`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 更新合同信息
  updateContract(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/device/base/contract/updateContract`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 根据id查询合同信息
  contractDetail(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/device/base/contract/findById/` + id).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 批量删除合同信息
  removecontracts(ids) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/device/base/contract/`, ids).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  fileUpload(data, cb) {
    req.post(portal + '/file/v1/relateBatch', data).then(rep => {
      if (rep.data) {
        cb(rep.data)
      }
    })
  },
  queryFile(data, cb) {
    req.post(portal + '/file/v1/query', data).then(rep => {
      if (rep.data) {
        cb(rep.data)
      }
    })
  },
  //获取用户信息
  getUserInfo() {
    return new Promise((resolve, reject) => {
      req.get(portal + `/api/user/v1/user/getDetailByAccount`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  removeFile(ids, cb) {
    console.log(ids);
    req.remove(portal + `/file/v1/?ids=` + ids).then(rep => {
      if (rep.data) {
        cb(rep.data)
      }
    })
  }
}

