import req from '@/request.js'
const portal = window.context.portal
export default {
    // 新增物资入库信息
    addIntoWarehouse(data, cb) {
        req.post(portal + `/manager/material/signWarehouse/`, data).then(res => {
            cb(res.data)
        })
    },
    // 修改物资入库信息
    editIntoWarehouse(data, cb) {
        req.put(portal + `/manager/material/signWarehouse/`, data).then(res => {
            cb(res.data)
        })
    },
    // 分页查询物资入库信息
    loadIntoWarehouse(data, cb) {
        req.post(portal + `/manager/material/signWarehouse/query`, data).then(res => {
            cb(res.data)
        })
    },
    getDetailById(data) {
        return new Promise((resolve, reject) => {
            req.get(portal + `/manager/material/signWarehouse/` + data).then(res => {
                resolve(res.data)
            })
        })
    },
    // 批量删除物资入库信息
    deleteIntoWarehouse(data, cb) {
        req.remove(portal + `/manager/material/signWarehouse/`, data).then(res => {
            cb(res.data)
        })
    },
    loadMaterialDetail(data, cb) {//获取物资详细
        req.post(portal + `/manager/material/into/warehouse/getDetailList`, data).then(res => {
            cb(res.data)
        })
    },

    findAllCustom(cb) {
        req.post(portal + '/manager/material/into/warehouse/allCustom').then(res => {
            cb(res.data)
        })
    },
    getOrderData(data, cb) {
        req.post(portal + '/manager/material/order/notSelectPage', data).then(res => {
            cb(res.data)
        })
    },
    // 获得订单下的物资详情
    getDetailList(id) {
        return new Promise((resolve, reject) => {
            req.get(portal + `/manager/material/order/` + id).then(
                resp => {
                    resolve(resp.data)
                },
                error => {
                    reject(error)
                }
            )
        })
    },

}