import req from '@/request.js'
const portal = window.context.portal
export default {
  //获取采购需求申请列表信息
  purchasingQuery(data, cb) {
    req.post(portal + `/manager/material/purchasing/query`, data).then(res => {
      cb(res.data)
    })
  },
  //获取物资领用申请单列表信息
  recipientsQuery(data, cb) {
    req.post(portal + `/manager/material/purchasing/recipientsQuery`, data).then(res => {
      cb(res.data)
    })
  },
  //采购需求申请申请单确认
  purchasingUpdateStatus(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/material/purchasing/updateStatus`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 根据条件获取该部门常用物资
  findByOrgUseDetail(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/material/usedDetail/findByOrgUseDetail`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //采购需求申请新增保存
  purchasingAdd(data, cb) {
    req.post(portal + `/manager/material/purchasing/add`, data).then(res => {
      cb(res.data)
    })
  },
  //采购需求申请编辑保存
  purchasingUpdate(data, cb) {
    req.put(portal + `/manager/material/purchasing/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 编辑获取申请单下所有物资明细
  getDetailListDetail(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/material/purchasing/getDetailList`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 物资供应商排序
  cmgtMaterialCustomManager(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/manager/cmgtMaterialCustom/updateSequence`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 修改物资供应商信息
  editCmgtMaterialCustom(data, cb) {
    req.put(portal + `/manager/cmgtMaterialCustom/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询物资供应商信息
  loadCmgtMaterialCustom(data, cb) {
    req.post(portal + `/manager/cmgtMaterialCustom/pageQuery`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除物资供应商信息
  deleteCmgtMaterialCustom(data, cb) {
    req.remove(portal + `/manager/cmgtMaterialCustom/delete`, data).then(res => {
      cb(res.data)
    })
  },
  // 批量删除物资申请信息
  deletePurchasing(data, cb) {
    req.remove(portal + `/manager/material/purchasing/delete?ids=`+ data).then(res => {
      cb(res.data)
    })
  },
}
