import req from '@/request.js'

const portal = window.context.portal
export default {
  // 获取视频目录
  getVideoF(data, cb) {
    req.post(portal + `/biz/catalog/base/getCataLogBase`, data).then(rep => {
      cb(rep.data)
    })
  },
  // 获取视频目录树
  getVideoTree(data, cb) {
    req.post(portal + `/biz/catalog/base/getTree`, data).then(rep => {
      cb(rep.data)
    })
  },
  //点击树获取分页
  getList(data, cb) {
    req.post(portal + `/biz/catalog/base/point/queryPointPage`, data).then(rep => {
      cb(rep.data)
    })
  },
  //获取分关监控点联页，不分页
  getListPage(data, cb) {
    req.post(portal + `/biz/catalog/base/findByZoneCode`, data).then(rep => {
      cb(rep.data)
    })
  },
  //同步检测点信息
  getSynch(data, cb) {
    req.post(portal + `/biz/catalog/base/asycZoneRes`, data).then(rep => {
      cb(rep.data)
    })
  },
  // 根据Id获取已关联的监控点
  RvdetailRelation(id, cb) {
    req.get(portal + `/att/rv/base/getVideoList/` + id).then(rep => {
      cb(rep.data)
    })
  },
  // 根据id查询视频点位信息
  InquireBasePoint(id, cb) {
    req.get(portal + `/biz/catalog/base/point/` + id).then(rep => {
      cb(rep.data)
    })
  },
  // 根据id获取已关联的监控点
  detailRelation(id, cb) {
    req.get(portal + `/att/res/base/getVideoList/` + id).then(rep => {
      cb(rep.data)
    })
  },

  // 根据id获取已关联的水电监控点
  HyddetailRelation(id, cb) {
    req.get(portal + `/att/hyst/base/getVideoList/` + id).then(rep => {
      cb(rep.data)
    })
  },
  //同步数据
  asycCataLog(cb) {
    req.post(portal + `/biz/catalog/base/asycCataLog`).then(rep => {
      cb(rep.data)
    })

  },
  //根据目录信息同步海康区域信息
  asycCataLogZone(data, cb) {
    req.post(portal + `/biz/catalog/base/asycCataLogZone`, data).then(rep => {
      cb(rep.data)
    })
  },
  // 获取视频点位信息
  getDetails(id, cb) {
    req.get(portal + `/biz/catalog/base/` + id).then(rep => {
      cb(rep.data)
    })
  },
  // 修改视频点位
  modifyPointExtend(data, cb) {
    req.put(portal + `/biz/catalog/base/updateById`, data).then(res => {
      cb(res.data)
    })
  },
  // 查询图标地址
  getIconAddress(id, cb) {
    req.get(portal + `/file/v1/fileGet?id=` + id).then(rep => {
      cb(rep.data)
    })
  },
  // 请求图片数据
  getIconData(data, cb) {
    req.get(portal + data).then(rep => {
      cb(rep.data)
    })
  },
  // 分页查询状态日志
  loadLog(data, cb) {
    req.post(portal + `/deviceStatusLog/v1/query`, data).then(rep => {
      cb(rep.data)
    })
  },
  // 分页查询
  loadInfo(data, cb) {
    req.post(portal + `/device/warnInfo/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 分页查询设备所属合同
  getDeviceList(data, cb) {
    req
      .post(portal + '/device/relation/contract/findByContractPage', data)
      .then(rep => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  // 新增视频区域
  addVideoArea(data, cb) {
    req
      .post(portal + '/biz/catalog/base/zone/', data)
      .then(rep => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  // 修改视频区域
  updateVideoArea(data, cb) {
    req
      .put(portal + '/biz/catalog/base/zone/', data)
      .then(rep => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  // 删除视频区域
  deleteVideoArea(data, cb) {
    req
      .remove(portal + '/biz/catalog/base/zone/' + data)
      .then(rep => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  // 新增视频监控点
  addVideoSite(data, cb) {
    req
      .post(portal + '/biz/catalog/base/point/', data)
      .then(rep => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  // 修改视频监控点
  updateVideoSite(data, cb) {
    req
      .put(portal + '/biz/catalog/base/point/', data)
      .then(rep => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  // 删除视频监控点
  deleteVideoSite(data, cb) {
    req
      .remove(portal + '/biz/catalog/base/point/' + data)
      .then(rep => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  },
  getVideoSiteById(data, cb) {
    req
      .get(portal + '/biz/catalog/base/point/' + data)
      .then(rep => {
        if (rep.data) {
          cb(rep.data)
        }
      })
  }
}
