import req from '@/request'
import qs from 'qs'

const portal = window.context.portal

// 新增案件
export function caseAdd(data = {}) {
  return new Promise((resolve, reject) => {
    req.post(portal + `/case/info/add`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 上传文件
export function fileUpload(data = {}) {
  return new Promise((resolve, reject) => {
    let formData = new FormData()
    Object.keys(data).forEach(key => {
      formData.append(key, data[key])
    })
    req.post(portal + `/file/v1/fileUpload`, formData)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}










