import req from '@/request.js'
import qs from 'qs'

const portal = window.context.portal
export default {
  // 新增勤务岗位信息
  getTableData(params, data, callback) {
    req.post(portal + `/manager/duty/member/statisticsWorkTime?${qs.stringify(params)}`, data)
      .then(res => callback && callback(res.data))
  },

  // 获取组织机构下拉
  getOrganizationData(callback) {
    req.request({
      method: 'GET',
      url: portal + '/manager/common/select/options',
      params: {name: 'manageCommonService.findZGJOrg'}
    }).then(res => callback && callback(res.data))
  },

  // 人员基本信息
  personalInformationData(id, callback) {
    req.get(portal + `/manager/duty/member/queryPersonBasicInfo?id=${id}`)
      .then(res => callback && callback(res.data.value))
  },

  // 预警信息
  warningInformationData(id, callback) {
    req.get(portal + `/manager/duty/member/queryPersonWarningInfo?id=${id}`)
      .then(res => callback && callback(res.data.value))
  },

  // 排班信息
  MonthSchedulingData(data) {
    return req.request({
      method: 'POST',
      url: portal + '/manager/cmgtDutyWorkarrange/query/findTeamMemberArrangeing',
      data
    })
  }
}
