import Vue from 'vue'
import VueRouter from 'vue-router'
import Home from '../views/main/HomePage/Home.vue'
import Layout from '../views/Layout.vue'

Vue.use(VueRouter)

const routes = [{
		path: "/",
		name: '',
		component: Layout,
		children: [{
				path: '',
				component: Home,
				meta: {
					isLogin: true
				},
			},
			{
			  path: "Worktable",
			  name: "Worktable",
			  component: () => import("../views/main/Worktable/index.vue"),
			  meta: [
			    {isLogin: true},
			    {name:'工作台'},
			    { name: '', url: '/Worktable' },
			  ]
			},
			{
			  path: "Worktable/unitDetails",
			  name: "unitDetails",
			  component: () => import("../views/main/Worktable/components/unitDetails.vue"),
			  // meta: [
			  //   {isLogin: true},
			  //   {name:'单位详情'},
			  //   { name: '', url: '/unitDetails' },
			  // ]
			},
			// {
			//   path: "Qunit",
			//   name: "Qunit",
			//   component: () => import("../views/main/Qunit/index.vue"),
			//   meta: [
			//     {isLogin: true},
			//     {name:'资质单位'},
			//     { name: '', url: '/Qunit' },
			//   ]
			// },
			{
        path: 'Qunit',
        name: 'Qunit',
        // component: () => import('../views/main/Qunit/index.vue'),
				/* 重定向二级路由到三级路由，解决二级路由跳转三级路由页面不显示 */
				component: { render(c) { return c('router-view') } },
				redirect: 'Qunit',
				/* 结束 */
        meta: [{ isLogin: true }, { name: '资质单位' }, { name: '', url: '/Qunit' }],
				children: [
				/* 重定向二级路由地址 */
					{
						path: '/Qunit',
						component: () => import('../views/main/Qunit/index.vue'),
					},
					/* 结束 */
          {
            path: 'Detils',
            name: 'Detils',
            component: () => import('../views/main/Qunit/detils.vue'),
            meta: [{ isLogin: true }, { name: '单位详细' }, { name: '', url: 'Qunit/Detils' }],
          },
        ],
      },
			{
			  path: "Qapplication",
			  name: "Qapplication",
			  component: () => import("../views/main/Qapplication/index.vue"),
			  meta: [
			    {isLogin: true},
			    {name:'资质申请'},
			    { name: '', url: '/Qapplication' },
			  ]
			},
			{
			  path: "Qapplication/applyDetails",
			  name: "applyDetails",
			  component: () => import("../views/main/Qapplication/components/applyDetails.vue"),
			},
			{
			  path: "Qmanagement",
			  name: "Qmanagement",
			  component: () => import("../views/main/Qmanagement/index.vue"),
			  meta: [
			    {isLogin: true},
			    {name:'资质管理'},
			    { name: '', url: '/Qmanagement' },
			  ]
			},
			{
			  path: "DataStatistics",
			  name: "DataStatistics",
			  component: () => import("../views/main/DataStatistics/index.vue"),
			  meta: [
			    {isLogin: true},
			    {name:'数据统计'},
			    { name: '', url: '/DataStatistics' },
			  ]
			},
			{
			  path: "Backlog",
			  name: "Backlog",
			  component: () => import("../views/main/Backlog/index.vue"),
			  meta: [
			    {isLogin: true},
			    {name:'待办流程'},
			    { name: '', url: '/Backlog' },
			  ]
			},
			
		]
	},
	{
		path: "/login",
		name: "Login",
		component: () => import("../views/Login.vue")
	}

]

const router = new VueRouter({
  mode: 'history',
  base: process.env.BASE_URL,
  routes,
})

export default router
