let DialogCodeHtml = {
  code: `<template>
  <div>
    <el-form data-vv-scope="form2">
      <el-form-item label="维度对话框">
        <div>
          <pre>{{data.demensions}}</pre>
          <el-button icon="el-icon-search" @click="showDialog('myDemensionDialog')">选择维度 值绑定方式</el-button>
          <el-button icon="el-icon-search" @click="showDialog('myDemensionDialog2')">选择维度 emit方式</el-button>
          <my-demension-dialog v-model="data.demensions" ref="myDemensionDialog"></my-demension-dialog>
          <my-demension-dialog @onConfirm="demensionDialogConfirm" ref="myDemensionDialog2"></my-demension-dialog>
        </div>
      </el-form-item>
      <el-form-item label="用户对话框">
        <div>
          <pre>{{data.users}}</pre>
          <el-button icon="el-icon-search" @click="showDialog('myUserDialog')">选择用户 值绑定方式 单选</el-button>
          <el-button icon="el-icon-search" @click="showDialog('myUserDialog2')">选择用户 emit方式 多选</el-button>
          <my-user-dialog v-model="data.users" ref="myUserDialog" single></my-user-dialog>
          <my-user-dialog ref="myUserDialog2" @onConfirm="userDialogConfirm"></my-user-dialog>
        </div>
      </el-form-item>
      <el-form-item label="组织对话框">
        <div>
          <pre>{{data.orgs}}</pre>
          <el-button icon="el-icon-search" @click="showDialog('myOrgDialog')">选择组织 值绑定方式 单选</el-button>
          <el-button icon="el-icon-search" @click="showDialog('myOrgDialog2')">选择组织 emit方式 多选</el-button>
          <my-org-dialog v-model="data.orgs" ref="myOrgDialog" single></my-org-dialog>
          <my-org-dialog ref="myOrgDialog2" @onConfirm="orgDialogConfirm"></my-org-dialog>
        </div>
      </el-form-item>
      <el-form-item label="岗位对话框">
        <div>
          <pre>{{data.posts}}</pre>
          <el-button icon="el-icon-search" @click="showDialog('myPostDialog')">选择岗位 值绑定方式 单选</el-button>
          <el-button icon="el-icon-search" @click="showDialog('myPostDialog2')">选择岗位 emit方式 多选</el-button>
          <my-post-dialog v-model="data.orgs" ref="myPostDialog" single></my-post-dialog>
          <my-post-dialog ref="myPostDialog2" @onConfirm="postDialogConfirm"></my-post-dialog>
        </div>
      </el-form-item>
    </el-form>
  </div>
</template>
<script>
import myUserDialog from "@/demo/MyUserDialog.vue";
import myDemensionDialog from "@/demo/MyDemensionDialog.vue";
import myOrgDialog from "@/demo/MyOrgDialog.vue";
import myPostDialog from "@/demo/MyPostDialog.vue";

export default {
  name: "dialog-code",
  components: {
    myUserDialog,
    myDemensionDialog,
    myOrgDialog,
    myPostDialog
  },
  data() {
    return {
      data: {
        users: [],
        demensions: [],
        orgs: [],
        posts:[]
      }
    };
  },
  methods: {
    showDialog(val) {
      this.$refs[val].showDialog();
    },
    userDialogConfirm: function(users) {
      this.data.users = users;
    },
    demensionDialogConfirm: function(selection) {
      this.data.demensions = selection;
    },
    orgDialogConfirm(selection) {
      this.data.orgs = selection;
    },
    postDialogConfirm(selection) {
      this.data.posts = selection;
    }
  }
};
</script>
`
}

export default DialogCodeHtml;