## ht-dialog 对话框组件

+ `ht-dialog`组件 
- props属性
|prop | 类型 |  默认值 | 说明|
|:-------|:-------|:-------|:-------|
|single | Boolean | false | 是否选择|
|data | Array | [] | 用户列表数据|
|tableColumns | Array | [] | 列表属性列配置|
|pagination | Object |  | 分页配置|
|selectLabel | String | fullname | 已选数据显示的label|
|appendToBody | Boolean | false | 是否嵌套打开对话框|
|searchPlaceholder | String | 请输入查询内容 | 查询条件的数据框placeholder|
|dialogTitle | String | 对话框 | 对话框标题|
|appendToBody | Boolean | false | 是否嵌套打开对话框|



- 事件方法

|事件 | 参数 | 说明|
|:-------|:-------|:-------|
|load | param,cb  | 查询列表数据 param 为queryFilter cb 为查询后的回调,打开对话框，或者输入查询条件时触发 |
|onConfirm | 已选数据 | 对话框点击确认时触发 |
|showDialog | 无 | 显示对话框 |

## my-demension-dialog 对话框组件
- 维度对话框 对ht-dialog使用示例代码
```html
<template>
  <ht-dialog
    :single="single"
    :data="data"
    :table-columns="tableColumns"
    :pagination="pagination"
    search-placeholder="名称或编码"
    dialog-title="维度对话框"
    @load="handleLoad"
    @onConfirm="onConfirm"
    ref="htDialog"
  />
</template>
<script>
import selector from "@/api/selector.js";

export default {
  name: "my-demension-dialog",
  props: {
    value: Array,
    name: String,
    single: Boolean,
  },
  data() {
    return {
      data: [],
      tableColumns:[
        {prop:"name",label:"名称",width:"300"},
        {prop:"code",label:"编码"}
      ],
      pagination: {
        page: 1,
        pageSize: 50,
        total: 0
      }
    };
  },
  methods: {
    showDialog(){
      this.$refs.htDialog.showDialog();
    },
    handleLoad(param, cb) {
      selector
        .getDem(param)
        .then(response => {
          this.data = response.result;
          this.pagination = response.pagination;
          cb();
        })
        .catch(err => {
          cb();
        });
    },
    onConfirm(selection) {
      this.$emit("onConfirm",selection);
      this.$emit("input",selection);
    }
  }
};
</script>
``` 

## `ht-user-dialog`组件
- props 属性说明

|prop | 类型 |  默认值 | 说明|
|:-------|:-------|:-------|:-------|
|demensions | Array | [] | 可选维度数组|
|orgs | Array | [] | 当前维度下的组织数据|
|loadOrgTree | Function | - | 异步加载组织树|
|single | Boolean | false | 是否选择|
|data | Array | [] | 用户列表数据|
|tableColumns | Array | [] | 列表属性列配置|
|pagination | Object | {page: 1,pageSize: 50,total: 0}  | 分页配置|
|selectLabel | String | fullname | 已选数据显示的label|
|appendToBody | Boolean | false | 是否嵌套打开对话框|

- 事件方法说明

|方法 | 参数 | 说明 |
|:-------|:-------|:-------|
|showDialog | 无 | 显示对话框|
|onConfirm | selectors | 对话框确认时回调方法|
|load | params,cb | 获取类表数据方法 params为queryFilter, cb为加载数据后的回调函数 |
|changeDemension |  currentDemension 维度id | 改变维度时触发的方法|
|loadOrgUser | org | 点击组织树时触发的方法|

## MyUserDialog.vue 用户对话框实现示例 （基于ht-user-dialog组件来实现）

```html
<template>
  <ht-user-dialog
    :single="single"
    :data="data"
    :table-columns="tableColumns"
    :pagination="pagination"
    :demensions="demensions"
    :orgs="orgs"
    :load-org-tree="loadOrgTree"
    @load="handleLoad"
    @changeDemension="changeDemension"
    @loadOrgUser="loadOrgUser"
    @onConfirm="onConfirm"
    select-label="fullname"
    ref="htUserDialog"
  />
</template>
<script>
import selector from "@/api/selector.js";
import req from "@/api/sysType.js";

export default {
  name: "my-user-dialog",
  props: {
    value: Array,
    single: Boolean,
  },
  data() {
    return {
      data: [],
      demensions:[{id:1,demName:"行政维度"},{id:2,demName:"分公司维度"}],
      orgs:[],
      tableColumns:[
        {prop:"fullname",label:"名称",width:"120"},
        {prop:"account",label:"账号",width:"120"},
        {prop:"email",label:"邮件",width:"260"}
      ],
      pagination: {
        page: 1,
        pageSize: 50,
        total: 0
      },
      orgLength: 0
    };
  },
  methods: {
    showDialog(){
      this.$refs.htUserDialog.showDialog();
    },
    handleLoad(param, cb) {
     this.$message('输入关键字查询用户');
      selector
        .getUsers(param)
        .then(response => {
          this.data = response.result;
          this.pagination = response.pagination;
          cb();
        })
        .catch(err => {
          cb();
        });
    },
    loadOrgTree(node, resolve){
      // 组织节点点击事件 异步加载组织
      this.$message('组织节点点击事件 请异步加载组织');
      let _this = this;

      req.getSysTypeData({})
      .then(function(data){
        // _this.orgs = data;
        var resultData = [{id:node.id,name:"组织"+node.id}];
        if(_this.orgLength>2){
         resultData = [];
        }
        _this.orgLength++;
        resolve(resultData);
      });
    },
    changeDemension(currentDemension){
      // 维度改变 重新获取组织
      this.$message('维度改变 请重新获取组织');
    },
    loadOrgUser(org){
      // 根据组织获取用户
    },
    onConfirm(selection){
      this.$emit("onConfirm",selection);
      this.$emit("input",selection);
    }
  }
};
</script>

```



