/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;

@WebSocket
public class JettyWebSocketHandlerAdapter {
    private static final ByteBuffer EMPTY_PAYLOAD = ByteBuffer.wrap(new byte[0]);
    private final WebSocketHandler delegateHandler;
    private final Function<Session, JettyWebSocketSession> sessionFactory;
    @Nullable
    private JettyWebSocketSession delegateSession;

    public JettyWebSocketHandlerAdapter(WebSocketHandler handler, Function<Session, JettyWebSocketSession> sessionFactory) {
        Assert.notNull((Object)handler, "WebSocketHandler is required");
        Assert.notNull(sessionFactory, "'sessionFactory' is required");
        this.delegateHandler = handler;
        this.sessionFactory = sessionFactory;
    }

    @OnWebSocketConnect
    public void onWebSocketConnect(Session session) {
        this.delegateSession = this.sessionFactory.apply(session);
        this.delegateHandler.handle(this.delegateSession).checkpoint(session.getUpgradeRequest().getRequestURI() + " [JettyWebSocketHandlerAdapter]").subscribe(this.delegateSession);
    }

    @OnWebSocketMessage
    public void onWebSocketText(String message) {
        if (this.delegateSession != null) {
            WebSocketMessage webSocketMessage = this.toMessage(WebSocketMessage.Type.TEXT, message);
            this.delegateSession.handleMessage(webSocketMessage.getType(), webSocketMessage);
        }
    }

    @OnWebSocketMessage
    public void onWebSocketBinary(byte[] message, int offset, int length) {
        if (this.delegateSession != null) {
            ByteBuffer buffer = ByteBuffer.wrap(message, offset, length);
            WebSocketMessage webSocketMessage = this.toMessage(WebSocketMessage.Type.BINARY, buffer);
            this.delegateSession.handleMessage(webSocketMessage.getType(), webSocketMessage);
        }
    }

    @OnWebSocketFrame
    public void onWebSocketFrame(Frame frame) {
        if (this.delegateSession != null && 10 == frame.getOpCode()) {
            ByteBuffer buffer = frame.getPayload() != null ? frame.getPayload() : EMPTY_PAYLOAD;
            WebSocketMessage webSocketMessage = this.toMessage(WebSocketMessage.Type.PONG, buffer);
            this.delegateSession.handleMessage(webSocketMessage.getType(), webSocketMessage);
        }
    }

    private <T> WebSocketMessage toMessage(WebSocketMessage.Type type, T message) {
        JettyWebSocketSession session = this.delegateSession;
        Assert.state(session != null, "Cannot create message without a session");
        if (WebSocketMessage.Type.TEXT.equals((Object)type)) {
            byte[] bytes = ((String)message).getBytes(StandardCharsets.UTF_8);
            DataBuffer buffer = session.bufferFactory().wrap(bytes);
            return new WebSocketMessage(WebSocketMessage.Type.TEXT, buffer);
        }
        if (WebSocketMessage.Type.BINARY.equals((Object)type)) {
            DataBuffer buffer = session.bufferFactory().wrap((ByteBuffer)message);
            return new WebSocketMessage(WebSocketMessage.Type.BINARY, buffer);
        }
        if (WebSocketMessage.Type.PONG.equals((Object)type)) {
            DataBuffer buffer = session.bufferFactory().wrap((ByteBuffer)message);
            return new WebSocketMessage(WebSocketMessage.Type.PONG, buffer);
        }
        throw new IllegalArgumentException("Unexpected message type: " + message);
    }

    @OnWebSocketClose
    public void onWebSocketClose(int statusCode, String reason) {
        if (this.delegateSession != null) {
            this.delegateSession.handleClose(CloseStatus.create(statusCode, reason));
        }
    }

    @OnWebSocketError
    public void onWebSocketError(Throwable cause) {
        if (this.delegateSession != null) {
            this.delegateSession.handleError(cause);
        }
    }
}

