/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

public class HandshakeInfo {
    private static final MultiValueMap<String, HttpCookie> EMPTY_COOKIES = CollectionUtils.toMultiValueMap(Collections.emptyMap());
    private final URI uri;
    private final Mono<Principal> principalMono;
    private final HttpHeaders headers;
    private final MultiValueMap<String, HttpCookie> cookies;
    @Nullable
    private final String protocol;
    @Nullable
    private final InetSocketAddress remoteAddress;
    private final Map<String, Object> attributes;
    @Nullable
    private final String logPrefix;

    public HandshakeInfo(URI uri, HttpHeaders headers2, Mono<Principal> principal2, @Nullable String protocol) {
        this(uri, headers2, EMPTY_COOKIES, principal2, protocol, null, Collections.emptyMap(), null);
    }

    @Deprecated
    public HandshakeInfo(URI uri, HttpHeaders headers2, Mono<Principal> principal2, @Nullable String protocol, @Nullable InetSocketAddress remoteAddress, Map<String, Object> attributes, @Nullable String logPrefix) {
        this(uri, headers2, EMPTY_COOKIES, principal2, protocol, remoteAddress, attributes, logPrefix);
    }

    public HandshakeInfo(URI uri, HttpHeaders headers2, MultiValueMap<String, HttpCookie> cookies, Mono<Principal> principal2, @Nullable String protocol, @Nullable InetSocketAddress remoteAddress, Map<String, Object> attributes, @Nullable String logPrefix) {
        Assert.notNull((Object)uri, "URI is required");
        Assert.notNull((Object)headers2, "HttpHeaders are required");
        Assert.notNull(cookies, "`cookies` are required");
        Assert.notNull(principal2, "Principal is required");
        Assert.notNull(attributes, "'attributes' is required");
        this.uri = uri;
        this.headers = headers2;
        this.cookies = cookies;
        this.principalMono = principal2;
        this.protocol = protocol;
        this.remoteAddress = remoteAddress;
        this.attributes = attributes;
        this.logPrefix = logPrefix;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, HttpCookie> getCookies() {
        return this.cookies;
    }

    public Mono<Principal> getPrincipal() {
        return this.principalMono;
    }

    @Nullable
    public String getSubProtocol() {
        return this.protocol;
    }

    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getLogPrefix() {
        return this.logPrefix;
    }

    public String toString() {
        return "HandshakeInfo[uri=" + this.uri + "]";
    }
}

