/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import org.springframework.util.Assert;
import org.springframework.web.reactive.result.view.UrlBasedViewResolver;

public class UrlBasedViewResolverRegistration {
    private final UrlBasedViewResolver viewResolver;

    public UrlBasedViewResolverRegistration(UrlBasedViewResolver viewResolver) {
        Assert.notNull((Object)viewResolver, "ViewResolver must not be null");
        this.viewResolver = viewResolver;
    }

    public UrlBasedViewResolverRegistration prefix(String prefix) {
        this.viewResolver.setPrefix(prefix);
        return this;
    }

    public UrlBasedViewResolverRegistration suffix(String suffix) {
        this.viewResolver.setSuffix(suffix);
        return this;
    }

    public UrlBasedViewResolverRegistration viewClass(Class<?> viewClass) {
        this.viewResolver.setViewClass(viewClass);
        return this;
    }

    public UrlBasedViewResolverRegistration viewNames(String ... viewNames) {
        this.viewResolver.setViewNames(viewNames);
        return this;
    }

    protected UrlBasedViewResolver getViewResolver() {
        return this.viewResolver;
    }
}

