/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import java.util.Collections;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.validation.support.BindingAwareConcurrentModel;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class BindingContext {
    @Nullable
    private final WebBindingInitializer initializer;
    private final Model model = new BindingAwareConcurrentModel();

    public BindingContext() {
        this(null);
    }

    public BindingContext(@Nullable WebBindingInitializer initializer) {
        this.initializer = initializer;
    }

    public Model getModel() {
        return this.model;
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange2, @Nullable Object target, String name) {
        ExtendedWebExchangeDataBinder dataBinder = new ExtendedWebExchangeDataBinder(target, name);
        if (this.initializer != null) {
            this.initializer.initBinder(dataBinder);
        }
        return this.initDataBinder(dataBinder, exchange2);
    }

    protected WebExchangeDataBinder initDataBinder(WebExchangeDataBinder binder, ServerWebExchange exchange2) {
        return binder;
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange2, String name) {
        return this.createDataBinder(exchange2, null, name);
    }

    private static class ExtendedWebExchangeDataBinder
    extends WebExchangeDataBinder {
        public ExtendedWebExchangeDataBinder(@Nullable Object target, String objectName) {
            super(target, objectName);
        }

        @Override
        public Mono<Map<String, Object>> getValuesToBind(ServerWebExchange exchange2) {
            return super.getValuesToBind(exchange2).doOnNext(map -> map.putAll(exchange2.getAttributeOrDefault(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, Collections.emptyMap())));
        }
    }
}

