/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.core;

import java.util.Optional;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.jetlinks.simulator.core.Connection;
import org.jetlinks.simulator.core.DefaultConnectionManager;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ConnectionManager
extends Disposable {
    public static ConnectionManager global() {
        return DefaultConnectionManager.global;
    }

    public long getConnectionSize();

    public Flux<Connection> getConnections();

    public Mono<Connection> getConnection(String var1);

    public Optional<Connection> getConnectionNow(String var1);

    public Flux<Connection> findConnection(String var1);

    public Flux<Connection> randomConnection(int var1);

    public ConnectionManager addConnection(Connection var1);

    default public Mono<Summary> summary() {
        return this.getConnections().reduce(new Summary(), Summary::add);
    }

    public static class Summary {
        private long size;
        private long connected;
        private long closed;
        private long sent;
        private long received;
        private long sentBytes;
        private long receivedBytes;

        public Summary add(Connection connection) {
            ++this.size;
            if (connection.state() == Connection.State.connected) {
                ++this.connected;
            } else {
                ++this.closed;
            }
            this.sent += connection.attribute("sent").map(CastUtils::castNumber).orElse(0).longValue();
            this.sentBytes += connection.attribute("sent_bytes").map(CastUtils::castNumber).orElse(0).longValue();
            this.received += connection.attribute("received").map(CastUtils::castNumber).orElse(0).longValue();
            this.receivedBytes += connection.attribute("received_bytes").map(CastUtils::castNumber).orElse(0).longValue();
            return this;
        }

        public Summary sub(Summary summary) {
            Summary sum = new Summary();
            sum.size = this.size - summary.size;
            sum.connected = this.connected - summary.connected;
            sum.closed = this.closed - summary.closed;
            sum.sent = this.sent - summary.sent;
            sum.received = this.received - summary.received;
            sum.sentBytes = this.sentBytes - summary.sentBytes;
            sum.receivedBytes = this.receivedBytes - summary.receivedBytes;
            return sum;
        }

        public Summary add(Summary summary) {
            Summary sum = new Summary();
            sum.size = this.size + summary.size;
            sum.connected = this.connected + summary.connected;
            sum.closed = this.closed + summary.closed;
            sum.sent = this.sent + summary.sent;
            sum.received = this.received + summary.received;
            sum.sentBytes = this.sentBytes + summary.sentBytes;
            sum.receivedBytes = this.receivedBytes + summary.receivedBytes;
            return sum;
        }

        public long getSize() {
            return this.size;
        }

        public long getConnected() {
            return this.connected;
        }

        public long getClosed() {
            return this.closed;
        }

        public long getSent() {
            return this.sent;
        }

        public long getReceived() {
            return this.received;
        }

        public long getSentBytes() {
            return this.sentBytes;
        }

        public long getReceivedBytes() {
            return this.receivedBytes;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setConnected(long connected) {
            this.connected = connected;
        }

        public void setClosed(long closed) {
            this.closed = closed;
        }

        public void setSent(long sent) {
            this.sent = sent;
        }

        public void setReceived(long received) {
            this.received = received;
        }

        public void setSentBytes(long sentBytes) {
            this.sentBytes = sentBytes;
        }

        public void setReceivedBytes(long receivedBytes) {
            this.receivedBytes = receivedBytes;
        }
    }
}

