/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd.upd;

import java.time.Duration;
import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.cmd.NetworkInterfaceCompleter;
import org.jetlinks.simulator.core.ExceptionUtils;
import org.jetlinks.simulator.core.network.udp.UDPClient;
import org.jetlinks.simulator.core.network.udp.UDPOptions;
import picocli.CommandLine;

@CommandLine.Command(name="create", showDefaultValues=true, description={"Create UDP Client"}, headerHeading="%n", sortOptions=false)
public class CreateUDPCommand
extends AbstractCommand
implements Runnable {
    @CommandLine.Mixin
    private Options options;

    @Override
    public void run() {
        this.printf("create udp client %s", this.options.getId());
        try {
            UDPClient client = UDPClient.create(this.options).block(Duration.ofSeconds(10L));
            if (client != null) {
                this.main().connectionManager().addConnection(client);
                this.printf(" success!%n", new Object[0]);
                this.main().getCommandLine().execute("udp", "attach", client.getId());
            } else {
                this.printf(" error:%n", new Object[0]);
            }
        }
        catch (Throwable err) {
            this.printfError(" error: %s %n", ExceptionUtils.getErrorMessage(err));
        }
    }

    static class Options
    extends UDPOptions {
        Options() {
        }

        @Override
        @CommandLine.Option(names={"--id"}, description={"Client ID"}, defaultValue="udp-client")
        public void setId(String id) {
            super.setId(id);
        }

        @Override
        @CommandLine.Option(names={"-h", "--host"}, description={"Remote host"})
        public void setHost(String host) {
            super.setHost(host);
        }

        @Override
        @CommandLine.Option(names={"-p", "--port"}, description={"Remote port"})
        public void setPort(int port) {
            super.setPort(port);
        }

        @Override
        @CommandLine.Option(names={"--interface"}, paramLabel="interface", description={"Network Interface"}, order=7, completionCandidates=NetworkInterfaceCompleter.class)
        public void setLocalAddress(String localAddress) {
            super.setLocalAddress(localAddress);
        }
    }
}

