/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd;

import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.io.File;
import org.jetlinks.simulator.cmd.NetworkInterfaceCompleter;
import picocli.CommandLine;

public class NetClientCommandOption
extends NetClientOptions {
    @CommandLine.Option(names={"--interface"}, paramLabel="interface", description={"Network Interface"}, order=40, completionCandidates=NetworkInterfaceCompleter.class)
    public void setLocalAddress0(String localAddress) {
        super.setLocalAddress(localAddress);
    }

    @CommandLine.Option(names={"--ssl"}, description={"Enable SSL"}, order=50, defaultValue="false")
    public void setSSL0(boolean trustAll) {
        this.setSsl(trustAll);
    }

    @CommandLine.Option(names={"--trustAll"}, description={"Trust All Server"}, order=51, defaultValue="true")
    public void setTrustAll0(boolean trustAll) {
        this.setTrustAll(trustAll);
    }

    @CommandLine.Option(names={"--key-path"}, description={"PEM format key path"}, order=52)
    public void setKeyPath(File path2) {
        this.keyOptions().addKeyPath(path2.getPath());
    }

    @CommandLine.Option(names={"--cert-path"}, description={"PEM format cert path"}, order=53)
    public void setCertPath(File path2) {
        this.keyOptions().addCertPath(path2.getPath());
    }

    @CommandLine.Option(names={"--trust-path"}, description={"PEM format trust cert path"}, order=54)
    public void setTrustPath(File path2) {
        this.trustOptions().addCertPath(path2.getPath());
    }

    public void apply(TCPSSLOptions another) {
        another.setSsl(this.isSsl());
        another.setPemTrustOptions(this.getPemTrustOptions());
        another.setPemKeyCertOptions(this.getPemKeyCertOptions());
        if (another instanceof ClientOptionsBase) {
            ((ClientOptionsBase)another).setLocalAddress(this.getLocalAddress());
        }
    }

    public PemKeyCertOptions keyOptions() {
        if (this.getPemKeyCertOptions() == null) {
            this.setPemKeyCertOptions(new PemKeyCertOptions());
        }
        return this.getPemKeyCertOptions();
    }

    public PemTrustOptions trustOptions() {
        if (this.getPemTrustOptions() == null) {
            this.setPemTrustOptions(new PemTrustOptions());
        }
        return this.getPemTrustOptions();
    }
}

