/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.simulator.cmd;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import org.jetlinks.simulator.cli.TerminalAppender;
import org.jetlinks.simulator.cmd.AbstractCommand;
import org.jetlinks.simulator.cmd.FullScreenCommand;
import org.jetlinks.simulator.history.CommandHistory;
import org.jline.builtins.Completers;
import org.jline.keymap.KeyMap;
import org.jline.reader.Candidate;
import org.jline.reader.History;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import org.springframework.util.StringUtils;
import picocli.CommandLine;
import picocli.shell.jline3.PicocliJLineCompleter;
import reactor.core.Disposable;

public class AttachCommand
extends FullScreenCommand {
    protected static final AttributedStyle helpBg = AttributedStyle.BOLD.background(87, 194, 197).foreground(0);
    protected static final AttributedStyle cursorStyle = AttributedStyle.BOLD.background(7).foreground(0);
    static Parser parser = new DefaultParser();
    protected StringBuilder editBuffer;
    private int curPos;
    private EditorOperation current;
    private int curIndex = 0;
    private boolean paused = false;
    private MouseEvent mouseEvent;
    private boolean windowsTerminal;
    private LinkedList<AttributedString> lastLines;
    private final Deque<AttributedString> errors = new ConcurrentLinkedDeque<AttributedString>();
    private final List<AttributedString> footers = new ArrayList<AttributedString>();
    private final StringWriter error = new StringWriter();
    private final StringWriter info = new StringWriter();
    private Disposable logDispose;
    private long lastShowTime = System.currentTimeMillis();

    @Override
    protected void destroy() {
        super.destroy();
        this.logDispose.dispose();
        this.errors.clear();
        this.logDispose = null;
        this.lastLines = null;
        try {
            this.history().save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected final void printf(String template, Object ... args) {
        this.info.append(String.format(template, args));
    }

    @Override
    protected final void printfError(String template, Object ... args) {
        this.error.append(AttachCommand.createLine(b -> b.append(String.format(template, args), red)).toString());
    }

    @Override
    protected void init() {
        this.logDispose = TerminalAppender.listenLog(log -> {
            for (String s2 : log.split("\n")) {
                this.errors.add(AttributedString.fromAnsi(s2));
                if (this.errors.size() <= 100) continue;
                this.errors.removeFirst();
            }
        });
        this.windowsTerminal = this.terminal.getClass().getSimpleName().endsWith("WinSysTerminal");
        this.editBuffer = new StringBuilder();
        this.error.getBuffer().setLength(0);
        this.info.getBuffer().setLength(0);
        this.footers.clear();
        this.curPos = 0;
        this.current = null;
        this.curIndex = 0;
        this.paused = false;
        this.terminal.trackMouse(Terminal.MouseTracking.Button);
    }

    protected void createHeader(List<AttributedString> lines) {
    }

    protected void createBody(List<AttributedString> lines) {
    }

    protected void createFooter(List<AttributedString> lines) {
        lines.addAll(this.footers);
        if (this.info.getBuffer().length() > 0) {
            for (String line : this.info.toString().split("\n")) {
                lines.add(AttributedString.fromAnsi(line));
            }
        }
        if (this.error.getBuffer().length() > 0) {
            for (String line : this.error.toString().split("\n")) {
                lines.add(AttributedString.fromAnsi(line));
            }
        }
    }

    protected AbstractCommand createCommand() {
        return null;
    }

    protected String inputHelp() {
        return "Command:";
    }

    private LinkedList<AttributedString> prepare(LinkedList<AttributedString> list) {
        int width = this.terminal.getWidth();
        LinkedList<AttributedString> newArr = new LinkedList<AttributedString>();
        for (AttributedString str : list) {
            int total = str.columnLength();
            if (total <= width) {
                newArr.add(str);
                continue;
            }
            for (int offset = 0; offset < total; offset += width) {
                newArr.add(str.columnSubSequence(offset, width + offset));
            }
        }
        return newArr;
    }

    @Override
    protected final synchronized boolean display() {
        if (this.paused || this.disposable == null || this.disposable.isDisposed()) {
            return true;
        }
        LinkedList<AttributedString> header = new LinkedList<AttributedString>();
        LinkedList<AttributedString> body2 = new LinkedList<AttributedString>(this.errors);
        LinkedList<AttributedString> footer = new LinkedList<AttributedString>();
        this.createHeader(header);
        this.createBody(body2);
        AttributedString input = AttachCommand.createLine(builder -> {
            builder.append(this.inputHelp(), helpBg);
            if (!this.showCursor()) {
                builder.append(this.editBuffer.toString());
                return;
            }
            if (this.curPos == 0 && this.editBuffer.length() > 0) {
                builder.append(this.editBuffer.substring(0, 1), cursorStyle);
                if (this.editBuffer.length() > 1) {
                    builder.append(this.editBuffer.substring(1, this.editBuffer.length()));
                }
            } else if (this.curPos < this.editBuffer.length()) {
                builder.append(this.editBuffer.substring(0, this.curPos));
                builder.append(this.editBuffer.substring(this.curPos, this.curPos + 1), cursorStyle);
                builder.append(this.editBuffer.substring(this.curPos + 1, this.editBuffer.length()));
            } else {
                builder.append(this.editBuffer.toString()).append(" ", cursorStyle);
            }
        });
        footer.add(input);
        this.createFooter(footer);
        while (footer.size() < 3) {
            footer.add(AttachCommand.createLine(builder -> builder.append("")));
        }
        header = this.prepare(header);
        body2 = this.prepare(body2);
        footer = this.prepare(footer);
        int bodyAliveHeight = this.terminal.getHeight() - footer.size() - header.size();
        while (body2.size() != bodyAliveHeight) {
            if (body2.size() > bodyAliveHeight) {
                if (body2.size() <= 0) break;
                body2.removeFirst();
                continue;
            }
            body2.add(AttributedString.EMPTY);
        }
        header.addAll(body2);
        header.addAll(footer);
        if (this.needFlush(header)) {
            this.display.clear();
        }
        this.lastLines = header;
        this.display.update(header, 0, true);
        return true;
    }

    protected boolean showCursor() {
        return true;
    }

    protected boolean needFlush(LinkedList<AttributedString> lines) {
        LinkedList<AttributedString> temp = this.lastLines;
        this.lastLines = lines;
        return this.windowsTerminal && !Objects.equals(lines, temp);
    }

    @Override
    protected void bindDefault(KeyMap<FullScreenCommand.Operation> keys) {
        keys.bind((FullScreenCommand.Operation)FullScreenCommand.DefaultOperation.EXIT, (CharSequence)KeyMap.ctrl('q'));
        keys.bind((FullScreenCommand.Operation)FullScreenCommand.DefaultOperation.CLEAR, (CharSequence)KeyMap.ctrl('c'));
        keys.setUnicode(EditorOperation.INSERT);
        for (char i2 = ' '; i2 < '\u0100'; i2 = (char)(i2 + '\u0001')) {
            keys.bind((FullScreenCommand.Operation)EditorOperation.INSERT, (CharSequence)Character.toString(i2));
        }
        keys.bind((FullScreenCommand.Operation)EditorOperation.TAP, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.tab));
        keys.bind((FullScreenCommand.Operation)EditorOperation.EXECUTE, "\r", KeyMap.key(this.terminal, InfoCmp.Capability.key_enter));
        keys.bind((FullScreenCommand.Operation)EditorOperation.RIGHT, KeyMap.key(this.terminal, InfoCmp.Capability.key_right), KeyMap.ctrl('b'));
        keys.bind((FullScreenCommand.Operation)EditorOperation.LEFT, KeyMap.key(this.terminal, InfoCmp.Capability.key_left), KeyMap.ctrl('f'));
        keys.bind((FullScreenCommand.Operation)EditorOperation.UP, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_up));
        keys.bind((FullScreenCommand.Operation)EditorOperation.DOWN, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_down));
        keys.bind((FullScreenCommand.Operation)EditorOperation.FIRST, (CharSequence)KeyMap.ctrl('a'));
        keys.bind((FullScreenCommand.Operation)EditorOperation.LAST, (CharSequence)KeyMap.ctrl('e'));
        keys.bind((FullScreenCommand.Operation)EditorOperation.BACKSPACE, KeyMap.ctrl('h'), KeyMap.del(), KeyMap.key(this.terminal, InfoCmp.Capability.delete_character));
        keys.bind((FullScreenCommand.Operation)EditorOperation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
    }

    @Override
    protected final boolean doOn(FullScreenCommand.Operation operation) {
        super.doOn(operation);
        this.paused = false;
        this.mouseEvent = null;
        if (operation instanceof EditorOperation) {
            EditorOperation opt = (EditorOperation)operation;
            switch (opt) {
                case EXECUTE: {
                    return this.execute();
                }
                case TAP: {
                    this.complete();
                    break;
                }
                case UP: {
                    this.history().previous();
                    this.showHistory();
                    break;
                }
                case DOWN: {
                    this.history().next();
                    this.showHistory();
                    break;
                }
                case MOUSE_EVENT: {
                    this.mouseEvent = this.terminal.readMouseEvent();
                    break;
                }
                default: {
                    this.curPos = this.editInputBuffer(opt, this.curPos);
                }
            }
        }
        return true;
    }

    private void showHistory() {
        String history = this.history().current();
        if (StringUtils.hasText(history)) {
            this.editBuffer.setLength(0);
            this.editBuffer.append(history);
            this.curPos = this.editBuffer.length();
        }
    }

    private boolean execute() {
        String command;
        switch (command = this.editBuffer.toString().trim()) {
            case "q:": 
            case "exit": {
                return false;
            }
            case "?": 
            case "": 
            case "help": {
                this.printf(this.commandLine().getUsageMessage(), new Object[0]);
                break;
            }
            case "clear": {
                this.doClear();
                this.clearFooter();
                this.display.clear();
                break;
            }
            default: {
                if (this.executeCommand(command)) {
                    this.history().add(command);
                    break;
                }
                return true;
            }
        }
        this.editBuffer.setLength(0);
        this.curPos = 0;
        return true;
    }

    protected History history() {
        return CommandHistory.getHistory(this.spec.qualifiedName("_"));
    }

    protected void doClear() {
        this.errors.clear();
    }

    private void clearFooter() {
        this.footers.clear();
        this.error.getBuffer().setLength(0);
        this.info.getBuffer().setLength(0);
    }

    private void complete() {
        this.clearFooter();
        String buffer = this.editBuffer.toString();
        CommandLine commandLine = this.commandLine();
        if (null != commandLine) {
            List<Candidate> candidates = new ArrayList<Candidate>();
            ParsedLine line = parser.parse(buffer, this.curPos);
            new AggregateCompleter(new PicocliJLineCompleter(commandLine.getCommandSpec()), new Completers.FileNameCompleter()).complete(new LineReaderImpl(this.terminal), line, candidates);
            String word = line.word();
            candidates = candidates.stream().filter(candidate -> this.matchComplete((Candidate)candidate, word)).collect(Collectors.toList());
            if (candidates.size() == 1) {
                ArrayList<String> w = new ArrayList<String>(line.words());
                String candidate2 = candidates.get(0).value();
                if (candidate2.startsWith(word)) {
                    w.set(w.size() - 1, candidate2);
                } else {
                    CharSequence[] arr = word.split("=");
                    if (arr.length == 2) {
                        arr[1] = candidate2;
                        w.set(w.size() - 1, String.join((CharSequence)"=", arr));
                    }
                }
                String val = String.join((CharSequence)" ", w);
                this.editBuffer.replace(0, this.curPos, val);
                this.curPos = val.length();
            } else if (candidates.size() > 1) {
                this.showComplete(candidates);
            }
        }
    }

    private boolean matchComplete(Candidate candidate, String word) {
        String[] arg = word.split("=");
        if (arg.length == 2) {
            word = arg[1];
        }
        return candidate.value().contains(word);
    }

    protected void showComplete(List<Candidate> candidates) {
        AttachCommand.createLine(builder -> {
            for (Candidate candidate : candidates) {
                String word = candidate.value();
                if (builder.columnLength() >= this.terminal.getWidth() - word.length()) {
                    this.footers.add(builder.toAttributedString());
                    builder.setLength(0);
                }
                builder.append(candidate.value(), blue).append("\t");
            }
            if (builder.length() > 0) {
                this.footers.add(builder.toAttributedString());
            }
        });
    }

    protected CommandLine commandLine() {
        AbstractCommand commands = this.createCommand();
        if (commands == null) {
            return null;
        }
        commands.setParent(this);
        CommandLine commandLine = new CommandLine(commands);
        commandLine.setErr(new PrintWriter(this.error));
        commandLine.setOut(new PrintWriter(this.info));
        return commandLine;
    }

    protected final boolean executeCommand(String command) {
        this.clearFooter();
        CommandLine commandLine = this.commandLine();
        if (commandLine == null) {
            this.footers.add(AttributedString.fromAnsi("unsupported command:" + command));
            return false;
        }
        ParsedLine line = parser.parse(command, command.length());
        int state = commandLine.execute(line.words().toArray(new String[0]));
        return this.error.getBuffer().length() == 0;
    }

    private int editInputBuffer(EditorOperation operation, int curPos) {
        switch (operation) {
            case INSERT: {
                this.editBuffer.insert(curPos++, this.bindingReader.getLastBinding());
                break;
            }
            case BACKSPACE: {
                if (curPos <= 0) break;
                this.editBuffer.deleteCharAt(--curPos);
                break;
            }
            case FIRST: {
                curPos = 0;
                break;
            }
            case LAST: {
                curPos = this.editBuffer.length();
                break;
            }
            case LEFT: {
                if (curPos <= 0) break;
                --curPos;
                break;
            }
            case RIGHT: {
                if (curPos >= this.editBuffer.length()) break;
                ++curPos;
            }
        }
        return curPos;
    }

    static enum EditorOperation implements FullScreenCommand.Operation
    {
        INSERT,
        BACKSPACE,
        PRE,
        NEXT,
        FIRST,
        LAST,
        LEFT,
        RIGHT,
        UP,
        DOWN,
        EXECUTE,
        TAP,
        MOUSE_EVENT,
        HELP;

    }
}

